% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEGIT.R
\name{predict.IMLEGIT}
\alias{predict.IMLEGIT}
\title{Predictions of IMLEGIT fits}
\usage{
\method{predict}{IMLEGIT}(object, data, latent_var, ...)
}
\arguments{
\item{object}{An object of class "IMLEGIT", usually, a result of a call to IMLEGIT.}

\item{data}{data.frame of the dataset to be used.}

\item{latent_var}{list of data.frame. The elements of the list are the datasets used to construct each latent variable. For interpretability and proper convergence, not using the same variable in more than one latent variable is highly recommended. It is recommended to set names to the list elements to prevent confusion because otherwise the latent variables will be named L1, L2, ...}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Returns a vector with the predicted values.
}
\description{
Predictions of IMLEGIT fits.
}
\examples{
train = example_2way(250, 1, seed=777)
test = example_2way(100, 1, seed=666)
fit = IMLEGIT(train$data, list(G=train$G, E=train$E), y ~ G*E)
ssres = sum((test$data$y - predict(fit, test$data, list(G=test$G, E=test$E)))^2)
sstotal = sum((test$data$y - mean(test$data$y))^2)
R2 = 1 - ssres/sstotal
R2
}
