% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresh_gam.R
\name{thresh_gam}
\alias{thresh_gam}
\title{Fits a GAM with a threshold-formulation}
\usage{
thresh_gam(model, ind_vec, press_vec, t_var, name_t_var, k, a, b)
}
\arguments{
\item{model}{A single GAM object from the model tibble needed to extract
the family and the link function.}

\item{ind_vec}{A vector with the IND training observations (including or excluding
defined outliers).}

\item{press_vec}{A vector with the training observations (including or excluding
defined outliers) of pressure 1 (i.e. the original significant pressure in the
GAM(M)).}

\item{t_var}{A vector with the training observations (including or excluding
defined outliers) of the threshold variable (i.e. a second pressure variable).}

\item{name_t_var}{The name of the threshold variable (pressure 2). t_var will be
named after this string in the model formula.}

\item{k}{Choice of knots (for the smoothing function \code{\link{s}}); the
default is 4 to avoid over-parameterization.}

\item{a}{The lower quantile value of the selected threshold variable, which
the estimated threshold is not allowed to exceed; the default is 0.2.}

\item{b}{The upper quantile value of the selected threshold variable, which
the estimated threshold is not allowed to exceed; the default is 0.8.}
}
\value{
The function returns a \code{gam} object with the additional class \code{tgam}.
All method functions for \code{gam} can be applied to this function. The object
has four additional elements:
\describe{
  \item{\code{mr}}{The threshold value of the best threshold-GAM.}
  \item{\code{mgcv}}{The GCV of the best threshold-GAM.}
  \item{\code{gcvv}}{A vector of the GCV values of all fitted threshold-GAMs.}
  \item{\code{t_val}}{A vector of all tested threshold values within the
             boundaries set by the lower and upper quantiles.}
  \item{\code{train_na}}{A logical vector indicating missing values.}
}
}
\description{
\code{thresh_gam} fits a Generalized Additive Model (GAM) with a threshold
formulation using the \code{by} argument in the smoothing function
\code{\link[mgcv]{s}}:
gam(IND ~ s(pressure1, by = threshold_variable_low) +
 s(pressure 1, by = threshold threshold_variable_high)).
The threshold value is estimated from the data and chosen by minimizing
the GCV score (termed "gcvv" in the threshold-GAM object) over an interval
defined by the lower and upper quantiles (see the \code{a} and \code{b}
arguments respectively) of the threshold variable.
}
\details{
\code{thresh_gam} creates first a sequence of evenly spaced threshold values
within the boundaries set by the lower and upper quantiles (defined by a and b).
For each threshold value that leads to a new splitting of the threshold
variables a threshold-GAM is applied: one smoothing function is applied
to only those observations where the threshold variable has been below the threshold
value for the given time step (year). A second smoothing function is applied to
observations where the threshold variable is above the prior defined threshold.
From the list of computed models the threshold-GAM with the lowest Generalized
Cross Validation (GCV) and its threshold value are selected and returned. For more
infos on threshold-GAMs see also the details section in \code{\link{test_interaction}}.
}
\examples{
# Using some models of the Baltic Sea demo data in this package
test <- thresh_gam(model = model_gam_ex$model[[1]],
  ind_vec = ind_init_ex$ind_train[[1]],
  press_vec = ind_init_ex$press_train[[1]],
  t_var = ind_init_ex$press_train[[2]],
  name_t_var = "Ssum", k = 4, a = 0.2, b = 0.8)
}
\seealso{
\code{\link{test_interaction}} and \code{\link{loocv_thresh_gam}}
 which apply the function
}
\keyword{internal}
