% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooSatpDs.R
\name{TSatp}
\alias{TSatp}
\title{Saturation Temperature, Function of pressure}
\usage{
TSatp(p)
}
\arguments{
\item{p}{Pressure [ MPa ]}
}
\value{
The Saturation Temperature: Tsat [ K ] and an Error Message 
    (if an error occur: \link{errorCodes})
}
\description{
The function \code{TSatp(p)} returns the temperature [K], 
    TSat, for given p [ MPa ]
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
p <- 0.932203564
TSatp(p)

}

