# Class input
# author: J.A. Torres-Matallana, U. Leopold
# organization: Luxembourg Institute of Science and technology (LIST)
#               Wagenigen university and Research Centre (WUR)   
# date: 11.02.2015 - 02.05.2019

input <- setClass("input", 
                  slots = c(spatial      = "numeric", 
                            zero         = "numeric", 
                            # mc = "numeric", 
                            folder       = "character", 
                            #folderOutput = "character",
                            cores        = "numeric", 
                            ww           = "list", 
                            inf          = "list", 
                            rw           = "list", 
                            P1           = "data.frame",
                            st           = "list",
                            pe.ts.file   = "character",
                            pe.daily.file= "data.frame", 
                            pe.weekly    = "list",
                            pe.seasonal  = "list",
                            qs.ts.file   = "character",
                            qs.daily.file= "data.frame", 
                            qs.weekly    = "list",
                            qs.seasonal  = "list",
                            export       = "numeric"),
                  prototype = list(spatial = 0,
                                   zero = 1E-5,
                                   # mc = 0,
                                   folder = system.file("shiny", package = "EmiStatR"),
                                   cores = 0,
                                   ww = NULL,
                                   inf = NULL,
                                   rw = NULL,
                                   P1 = NULL,
                                   st = NULL,
                                   pe.ts.file    = "",
                                   pe.daily.file = data.frame(time = c("00:00:00",
                                                                       "00:02:00",
                                                                       "00:04:00",
                                                                       "00:06:00",
                                                                       "00:08:00",
                                                                       "00:10:00",
                                                                       "00:12:00",
                                                                       "00:14:00",
                                                                       "00:16:00",
                                                                       "00:18:00",
                                                                       "00:20:00",
                                                                       "00:22:00"),
                                                              pe_factor = rep(1,12)),
                                   pe.weekly     = list(mon=1, tue=1, wed=1, thu=1, fri=1, sat=1, sun=1),
                                   pe.seasonal   = list(jan=1, feb=1, mar=1, apr=1, may=1, jun=1, 
                                                        jul=1, aug=1, sep=1, oct=1, nov=1, dec=1),
                                   qs.ts.file    = "",
                                   qs.daily.file = data.frame(time = c("00:00:00",
                                                                       "00:02:00",
                                                                       "00:04:00",
                                                                       "00:06:00",
                                                                       "00:08:00",
                                                                       "00:10:00",
                                                                       "00:12:00",
                                                                       "00:14:00",
                                                                       "00:16:00",
                                                                       "00:18:00",
                                                                       "00:20:00",
                                                                       "00:22:00"),
                                                              qs_factor = rep(1,12)),
                                   qs.weekly     = list(mon=1, tue=1, wed=1, thu=1, fri=1, sat=1, sun=1),
                                   qs.seasonal   = list(jan=1, feb=1, mar=1, apr=1, may=1, jun=1, 
                                                        jul=1, aug=1, sep=1, oct=1, nov=1, dec=1),
                                   export = 1)
)
