% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background.test.R
\name{background.test}
\alias{background.test}
\title{background.test Conduct a background test (also called a similarity test), as described in Warren et al. 2008.
This test can either be run as an asymmetric test (species.1 vs background of species.2) or as a symmetric test
(background of species.1 vs background of species.2).  For GLM, Bioclim, and Domain models the replicates will be
constructed from the background points supplied for each species.  For Maxent, the replicates will be constructed
from the range rasters stored in the enmtools.species objects.}
\usage{
background.test(
  species.1,
  species.2,
  env,
  type,
  f = NULL,
  nreps = 99,
  test.type = "asymmetric",
  nback = 1000,
  bg.source = "default",
  low.memory = FALSE,
  rep.dir = NA,
  verbose = FALSE,
  clamp = TRUE,
  ...
)
}
\arguments{
\item{species.1}{An emtools.species object from which presence points (asymmetric) or background (symmetric) will be sampled.}

\item{species.2}{An enmtools.species object from which background will be sampled.}

\item{env}{A SpatRaster object containing environmental data}

\item{type}{The type of model to construct, currently accepts "glm", "mx", "bc", "gam", or "dm"}

\item{f}{A function to use for model fitting.  Only required for GLM models at the moment.}

\item{nreps}{Number of replicates to perform}

\item{test.type}{Controls whether the background test will be "symmetric" or "asymmetric"}

\item{nback}{Number of background points for models}

\item{bg.source}{Source for drawing background points.  If "points", it just uses the background points that are already in the species object.  If "range", it uses the range raster.  If "env", it draws points at randome from the entire study area outlined by the first environmental layer.}

\item{low.memory}{When set to TRUE, replicate models are written to disc instead of being stored in the output object.  Replicate models stored in the output object contain paths to the replicate models on disk instead of the rasters themselves.}

\item{rep.dir}{Directory for storing replicate models when low.memory is set to TRUE.  If not specified, the working directory will be used.}

\item{verbose}{Controls printing of various messages progress reports.  Defaults to FALSE.}

\item{clamp}{Controls whether empirical and replicate models should be clamped to the environment space used for training.}

\item{...}{Additional arguments to be passed to model fitting functions.}
}
\value{
results A list containing replicates, models for the empirical data, and summary statistics and plots.
}
\description{
background.test Conduct a background test (also called a similarity test), as described in Warren et al. 2008.
This test can either be run as an asymmetric test (species.1 vs background of species.2) or as a symmetric test
(background of species.1 vs background of species.2).  For GLM, Bioclim, and Domain models the replicates will be
constructed from the background points supplied for each species.  For Maxent, the replicates will be constructed
from the range rasters stored in the enmtools.species objects.
}
\examples{
\donttest{
cyreni <- iberolacerta.clade$species$cyreni
monticola <- iberolacerta.clade$species$monticola
cyreni$range <- background.raster.buffer(cyreni$presence.points, 100000, euro.worldclim)
monticola$range <- background.raster.buffer(monticola$presence.points, 100000, euro.worldclim)
background.test(cyreni, monticola, env = euro.worldclim, type = "glm",
f = pres ~ bio1 + bio12, nreps = 10)
}
}
\keyword{background}
\keyword{enmtools}
\keyword{equivalency}
\keyword{hypothesis}
\keyword{testing}
