% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_sampling.R
\name{declare_sampling}
\alias{declare_sampling}
\alias{sampling_handler}
\title{Declare sampling procedure}
\usage{
declare_sampling(..., handler = sampling_handler, label = NULL)

sampling_handler(data, ..., legacy = FALSE)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}

\item{data}{A data.frame.}

\item{legacy}{Use the legacy randomizr functionality. This will be disabled in future; please use legacy = FALSE.}
}
\value{
A sampling declaration, which is a function that takes a data.frame as an argument and returns a data.frame subsetted to sampled observations and (optionally) augmented with inclusion probabilities and other quantities.
}
\description{
Declare sampling procedure
}
\examples{

design <- declare_model(

  classrooms = add_level(10),
  individuals = add_level(20, female = rbinom(N, 1, 0.5))

) + NULL

# Complete random sampling

design + declare_sampling(
  S = complete_rs(N = N, n = 50), 
  filter = S == 1)

# equivalently, by default filter is set to S == 1
design + declare_sampling(S = complete_rs(N = N, n = 50), 
                          legacy = FALSE)

# Stratified random sampling

design + declare_sampling(S = strata_rs(strata = female), 
                          legacy = FALSE)
}
