% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatFunctions.R
\name{meanDP}
\alias{meanDP}
\title{Differentially Private Mean}
\usage{
meanDP(
  x,
  eps,
  lower.bound,
  upper.bound,
  which.sensitivity = "bounded",
  mechanism = "Laplace",
  delta = 0,
  type.DP = "aDP"
)
}
\arguments{
\item{x}{Dataset whose mean is desired.}

\item{eps}{Positive real number defining the epsilon privacy budget.}

\item{lower.bound}{Scalar representing the global or public lower bound on
values of x.}

\item{upper.bound}{Scalar representing the global or public upper bound on
values of x.}

\item{which.sensitivity}{String indicating which type of sensitivity to use.
Can be one of \{'bounded', 'unbounded', 'both'\}. If 'bounded' (default),
returns result based on bounded definition for differential privacy. If
'unbounded', returns result based on unbounded definition. If 'both',
returns result based on both methods \insertCite{Kifer2011}{DPpack}. Note
that if 'both' is chosen, each result individually satisfies (eps,
delta)-differential privacy, but may not do so collectively and in
composition. Care must be taken not to violate differential privacy in this
case.}

\item{mechanism}{String indicating which mechanism to use for differential
privacy. Currently the following mechanisms are supported: \{'Laplace',
'Gaussian', 'analytic'\}. Default is Laplace. See \code{\link{LaplaceMechanism}},
\code{\link{GaussianMechanism}}, and
\code{\link{AnalyticGaussianMechanism}} for descriptions of the supported
mechanisms.}

\item{delta}{Nonnegative real number defining the delta privacy parameter. If
0 (default), reduces to eps-DP.}

\item{type.DP}{String indicating the type of differential privacy desired for
the Gaussian mechanism (if selected). Can be either 'pDP' for probabilistic
DP \insertCite{Machanavajjhala2008}{DPpack} or 'aDP' for approximate DP
\insertCite{Dwork2006b}{DPpack}. Note that if 'aDP' is chosen, epsilon must
be strictly less than 1.}
}
\value{
Sanitized mean based on the bounded and/or unbounded definitions of
differential privacy.
}
\description{
This function computes the differentially private mean of a given dataset at
user-specified privacy levels of epsilon and delta.
}
\examples{
D <- stats::rnorm(500, mean=3, sd=2)
lb <- -3 # 3 std devs below mean
ub <- 9 # 3 std devs above mean
meanDP(D,  1, lb, ub)
meanDP(D, .5, lb, ub, which.sensitivity='unbounded', mechanism='Gaussian',
  delta=0.01)

}
\references{
\insertRef{Dwork2006a}{DPpack}

\insertRef{Kifer2011}{DPpack}

\insertRef{Machanavajjhala2008}{DPpack}

\insertRef{Dwork2006b}{DPpack}
}
