% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.DIFtree.R
\name{predict.DIFtree}
\alias{predict.DIFtree}
\title{Prediction from fitted Item focussed Trees}
\usage{
\method{predict}{DIFtree}(object, item, newdata, ...)
}
\arguments{
\item{object}{Object of class \code{\link[DIFtree]{DIFtree}}}

\item{item}{Number of the item, for which the prediction shall be returned}

\item{newdata}{New data.frame, for which the prediction shall be returned}

\item{...}{Further arguments passed to or from other methods}
}
\description{
The function returns predictions of item parameters 
obtained by item focussed recursive partitioning in dichotomous or polytomous items.
}
\details{
For \code{"Rasch"} model the function returns the predicted item difficulty. 
For \code{"Logistic"} models the function returns the predicted intercept and/or slope.  
For \code{"PCM"} the function returns the predicted threshold parameters.
}
\examples{
data(data_sim_Rasch)
 
Y <- data_sim_Rasch[,1]
X <- data_sim_Rasch[,-1]

Xnew <- data.frame("x1"=c(0,1),"x2"=c(-1.1,2.5),"x3"=c(1,0),"x4"=c(-0.2,0.7))
 
\dontrun{
 
mod <- DIFtree(Y=Y,X=X,model="Logistic",type="udif",alpha=0.05,nperm=1000,trace=TRUE)
 
predict(mod,item=1,Xnew)
}

}
\references{
Berger, Moritz and Tutz, Gerhard (2016): Detection of Uniform and Non-Uniform Differential Item Functioning 
by Item Focussed Trees, Journal of Educational and Behavioral Statistics 41(6), 559-592.

Bollmann, Stella, Berger, Moritz & Tutz, Gerhard (2018): Item-Focussed Trees for the Detection 
of Differential Item Functioning in Partial Credit Models, Educational and Psychological Measurement 78(5), 781-804.

Tutz, Gerhard and Berger, Moritz (2016): Item focussed Trees for the Identification of Items
in Differential Item Functioning, Psychometrika 81(3), 727-750.
}
\seealso{
\code{\link[DIFtree]{DIFtree}}, \code{\link[DIFtree]{plot.DIFtree}}, \code{\link[DIFtree]{summary.DIFtree}}
}
\author{
Moritz Berger <moritz.berger@imbie.uni-bonn.de> \cr \url{http://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
