% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_cox.R
\name{cox}
\alias{cox}
\title{cox}
\usage{
cox(
  X,
  Y,
  x.center = TRUE,
  x.scale = FALSE,
  remove_near_zero_variance = TRUE,
  remove_zero_variance = FALSE,
  toKeep.zv = NULL,
  remove_non_significant = FALSE,
  alpha = 0.05,
  MIN_EPV = 5,
  FORCE = FALSE,
  returnData = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{X}{Numeric matrix or data.frame. Explanatory variables. Qualitative variables must be
transform into binary variables.}

\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and
event observations.}

\item{x.center}{Logical. If x.center = TRUE, X matrix is centered to zero means (default: TRUE).}

\item{x.scale}{Logical. If x.scale = TRUE, X matrix is scaled to unit variances (default: FALSE).}

\item{remove_near_zero_variance}{Logical. If remove_near_zero_variance = TRUE, near zero variance
variables will be removed (default: TRUE).}

\item{remove_zero_variance}{Logical. If remove_zero_variance = TRUE, zero variance variables will
be removed (default: TRUE).}

\item{toKeep.zv}{Character vector. Name of variables in X to not be deleted by (near) zero variance
filtering (default: NULL).}

\item{remove_non_significant}{Logical. If remove_non_significant = TRUE, non-significant
variables/components in final cox model will be removed until all variables are significant by
forward selection (default: FALSE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the threshold
(default: 0.05).}

\item{MIN_EPV}{Numeric. Minimum number of Events Per Variable (EPV) you want reach for the final
cox model. Used to restrict the number of variables/components can be computed in final cox models.
If the minimum is not meet, the model cannot be computed (default: 5).}

\item{FORCE}{Logical. In case the MIN_EPV is not meet, it allows to compute the model (default: FALSE).}

\item{returnData}{Logical. Return original and normalized X and Y matrices (default: TRUE).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}
}
\value{
Instance of class "Coxmos" and model "cox". The class contains the following elements:

\code{X}: List of normalized X data information.
\itemize{
\item \code{(data)}: normalized X matrix
\item \code{(x.mean)}: mean values for X matrix
\item \code{(x.sd)}: standard deviation for X matrix
}
\code{Y}: List of normalized Y data information.
\itemize{
\item \code{(data)}: normalized Y matrix
\item \code{(y.mean)}: mean values for Y matrix
\item \code{(y.sd)}: standard deviation for Y matrix
}
\code{survival_model}: List of survival model information
\itemize{
\item \code{fit}: coxph object.
\item \code{AIC}: AIC of cox model.
\item \code{BIC}: BIC of cox model.
\item \code{lp}: linear predictors for train data.
\item \code{coef}: Coefficients for cox model.
\item \code{YChapeau}: Y Chapeau residuals.
\item \code{Yresidus}: Y residuals.
}
\code{call}: call function

\code{X_input}: X input matrix

\code{Y_input}: Y input matrix

\code{nsv}: Variables removed by remove_non_significant if any.

\code{nzv}: Variables removed by remove_near_zero_variance or remove_zero_variance.

\code{nz_coeffvar}: Variables removed by coefficient variation near zero.

\code{removed_variables_correlation}: Variables removed by being high correlated with other
variables.

\code{class}: Model class.

\code{time}: time consumed for running the cox analysis.
}
\description{
The \code{cox} function conducts a Cox proportional hazards regression analysis, a type of survival
analysis. It is designed to handle right-censored data and is built upon the \code{coxph} function from
the \code{survival} package. The function returns an object of class "Coxmos" with the attribute model
labeled as "cox".
}
\details{
The Cox proportional hazards regression model is a linear model that describes the relationship
between the hazard rate and one or more predictor variables. The function provided here offers
several preprocessing steps to ensure the quality and robustness of the model.

The function allows for the centering and scaling of predictor variables, which can be essential
for the stability and interpretability of the model. It also provides options to remove variables
with near-zero or zero variance, which can be problematic in regression analyses. Such variables
offer little to no information and can lead to overfitting.

Another notable feature is the ability to remove non-significant predictors from the final model
through a backward selection process. This ensures that only variables that contribute significantly
to the model are retained.

The function also checks for the minimum number of events per variable (EPV) to ensure the
robustness of the model. If the specified EPV is not met, the function can either halt the
computation or proceed based on user preference.

It's important to note that while this function is tailored for standard Cox regression, it might
not be suitable for high-dimensional data. In such cases, users are advised to consider alternative
methods like \code{coxEN()} or PLS-based Cox methods.
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X <- X_proteomic[,1:10]
Y <- Y_proteomic
cox(X, Y, x.center = TRUE, x.scale = TRUE)
}
\references{
\insertRef{Cox_1972}{Coxmos}
\insertRef{Concato_1995}{Coxmos}
\insertRef{survival_package}{Coxmos}
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
