% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{AP_preferenceRange}
\alias{AP_preferenceRange}
\title{Affinity propagation preference range}
\usage{
AP_preferenceRange(data, method = "bound", threads = 1)
}
\arguments{
\item{data}{a matrix. Either a similarity matrix (where number of rows equal to number of columns) or a 3-dimensional matrix where the 1st, 2nd and 3rd column correspond to (i-index, j-index, value) triplet of a similarity matrix.}

\item{method}{a character string specifying the preference range method to use. One of 'exact', 'bound'. See the details section for more information.}

\item{threads}{an integer specifying the number of cores to run in parallel ( applies only if \emph{method} is set to 'exact' which is more computationally intensive )}
}
\description{
Affinity propagation preference range
}
\details{
Given a set of similarities, \emph{data}, this function computes a lower bound, pmin, on the value for the preference where the optimal number of clusters (exemplars) changes from 1 to 2,
and the exact value of the preference, pmax, where the optimal number of clusters changes from n-1 to n. For N data points, there may be as many as N^2-N pair-wise similarities (note that
the similarity of data point i to k need not be equal to the similarity of data point k to i). These may be passed in an NxN matrix of similarities, \emph{data}, where data(i,k) is the similarity of
point i to point k. In fact, only a smaller number of relevant similarities need to be provided, in which case the others are assumed to be -Inf. M similarity values are known, can be passed
in an Mx3 matrix \emph{data}, where each row of \emph{data} contains a pair of data point indices and a corresponding similarity value: data(j,3) is the similarity of data point data(j,1) to
data point data(j,2).

A single-cluster solution may not exist, in which case pmin is set to NaN. The \emph{AP_preferenceRange} uses one of the methods below to compute pmin and pmax:

\emph{exact} : Computes the exact values for pmin and pmax (Warning: This can be quite slow)
\emph{bound} : Computes the exact value for pmax, but estimates pmin using a bound (default)
}
\examples{

set.seed(1)
dat = matrix(sample(1:255, 2500, replace = TRUE), 100, 25)

smt = 1.0 - distance_matrix(dat, method = 'euclidean', upper = TRUE, diagonal = TRUE)
diag(smt) = 0.0

ap_range = AP_preferenceRange(smt, method = "bound")

}
\references{
https://www.psi.toronto.edu/affinitypropagation/preferenceRange.m
}
