% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveySpectra.R, R/surveySpectra2.R
\name{surveySpectra}
\alias{surveySpectra}
\alias{surveySpectra2}
\title{Plot Measures of Central Tendency and Spread for a Spectra Object}
\usage{
surveySpectra(
  spectra,
  method = c("sd", "sem", "sem95", "mad", "iqr"),
  by.gr = TRUE,
  ...
)

surveySpectra2(
  spectra,
  method = c("sd", "sem", "sem95", "mad", "iqr"),
  lab.pos = 0.9 * max(spectra$freq),
  ...
)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[=Spectra]{Spectra()}}.}

\item{method}{Character.  One of \code{c("sd", "sem", "sem95", "mad",
"iqr")}.}

\item{by.gr}{Logical, indicating if the analysis is to be done by group or
not. Applies to \code{surveySpectra} only.}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}

\item{lab.pos}{Numeric, giving the frequency where the label should be drawn.
Applies to \code{surveySpectra2} only.}
}
\value{
The returned value depends on the graphics option selected (see \code{\link[ChemoSpecUtils:GraphicsOptions]{ChemoSpecUtils::GraphicsOptions()}}).
\itemize{
\item \code{base}: None.  Side effect is a plot.
\item \code{ggplot2}: The plot is displayed, and a \code{ggplot2} object is returned if the value is assigned.  The plot can be modified in the usual \code{ggplot2} manner.
}
}
\description{
Compute and plot various measures of central tendency and
spread for a \code{\link{Spectra}} object.  Several different measures/spreads
are available.  These are useful as an overview of where a data set varies
the most.
}
\details{
For \code{surveySpectra} the method choice works as follows: \code{sd} plots
the mean spectrum +/- the standard deviation, \code{sem} plots the mean
spectrum +/- the standard error of the mean, \code{sem95} plots the mean
spectrum +/- the standard error at the 95 percent confidence interval,
\code{mad} plots the median spectrum +/- the median absolute deviation, and
finally, \code{iqr} plots the median spectrum + the upper hinge and - the
lower hinge.

For \code{surveySpectra2}, the spectra are mean centered and plotted.  Below
that, the relative summary statistic is plotted, offset, but on the same
scale.
}
\section{Functions}{
\itemize{
\item \code{surveySpectra()}: Spectral survey emphasizing mean or median spectrum, optionally by group.

\item \code{surveySpectra2()}: Spectral survey emphasizing variation among spectra.

}}
\examples{

# This example assumes the graphics output is set to ggplot2 (see ?GraphicsOptions).
library("ggplot2")
data(SrE.IR)
myt <- expression(bolditalic(Serenoa) ~ bolditalic(repens) ~ bold(Extract ~ IR ~ Spectra))

p1 <- surveySpectra(SrE.IR, method = "iqr")
p1 <- p1 + ggtitle(myt)
p1

p2 <- surveySpectra2(SrE.IR, method = "iqr")
p2 <- p2 + ggtitle(myt)
p2

}
\seealso{
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Tejasvi Gupta.
}
\keyword{hplot}
