% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dag.R
\name{plot_dag}
\alias{plot_dag}
\title{Plots a DAG in ggplot style using a causal model input}
\usage{
plot_dag(
  model = NULL,
  x_coord = NULL,
  y_coord = NULL,
  title = "",
  textcol = "white",
  textsize = 3.88,
  shape = 16,
  nodecol = "black",
  nodesize = 16
)
}
\arguments{
\item{model}{A \code{causal_model} object generated from \code{make_model}}

\item{x_coord}{A vector of x coordinates for DAG nodes. If left empty, coordinates are randomly generated}

\item{y_coord}{A vector of y coordinates for DAG nodes. If left empty, coordinates are randomly generated}

\item{title}{String specifying title of graph}

\item{textcol}{String specifying color of text labels}

\item{textsize}{Numeric, size of text labels}

\item{shape}{Indicates shape of node. Defaults to circular node.}

\item{nodecol}{String indicating color of node that is accepted by ggplot's default palette}

\item{nodesize}{Size of node.}
}
\value{
A DAG plot in ggplot style.
}
\description{
If confounds are indicated (provided in \code{attr(model$P, 'confounds')}), then these are represented as bidirectional arcs. Builds on functionality from ggdag and dagitty.
}
\examples{

\dontrun{
model <- make_model('X -> K -> Y; X <-> Y')

model |>
  CausalQueries:::plot_dag()
model |>
  CausalQueries:::plot_dag(
    x_coord = 1:3,
    y_coord = 1:3,
    title = "Mixed text and math: $\\\\alpha^2 + \\\\Gamma$")
}

}
\keyword{internal}
