% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_linearEffects.R
\name{plot_linearEffects}
\alias{plot_linearEffects}
\title{Plot linear effects of a gam in an effect plot}
\usage{
plot_linearEffects(model)
}
\arguments{
\item{model}{Model fitted with \code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.}
}
\value{
ggplot object
}
\description{
Create an effect plot of linear effects of a model fitted with
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.
}
\details{
If the model was estimated with a log or logit link, the function
automatically performs an exponential transformation of the effect.
}
\examples{
library(APCtools)
library(mgcv)

data(travel)
model <- gam(mainTrip_distance ~ te(age, period) + residence_region +
             household_size + s(household_income), data = travel)

plot_linearEffects(model)

}
\author{
Alexander Bauer \email{alexander.bauer@stat.uni-muenchen.de}
}
