library(shiny)
library(shinyNextUI)
library(shiny.react)

# Data can also be a list of lists.
dt <- list(
  # Row 1
  list(
    col1 = avatar(name = "pouet"),
    col2 = chip("Chip", color = "success", variant = "flat"),
    col3 = circular_progress(
      value = 100,
      showValueLabel = TRUE,
      strokeWidth = 4,
      size = "lg",
      minValue = 0,
      maxValue = 150,
      valueLabel = 100,
      color = "warning"
    )
  )
  # Row 2 ...
)

ui <- nextui_page(
  dark_mode = TRUE,
  spacer(y = 5),
  p(class = "font-extrabold text-2xl uppercase my-2", "No data"),
  spacer(y = 2),
  table(iris[0, ], hideHeader = TRUE),
  spacer(y = 5),
  p(class = "font-extrabold text-2xl uppercase my-2", "Pass data as a list"),
  table(dt),
  spacer(y = 5),
  p(class = "font-extrabold text-2xl uppercase my-2", "Single selection table"),
  spacer(y = 2),
  table(
    iris[1:5, ],
    removeWrapper = TRUE,
    isStriped = TRUE,
    color = "primary",
    selectionMode = "single",
    defaultSelectedKeys = JS("['2']")
  ),
  spacer(y = 5),
  p(
    class = "font-extrabold text-2xl uppercase my-2",
    "Multiple selection table"
  ),
  spacer(y = 2),
  table(
    iris[1:5, ],
    color = "primary",
    selectionMode = "multiple",
    defaultSelectedKeys = JS("['1', '2']"),
    disabledKeys = JS("['3']")
  ),
  spacer(y = 5),
  p(class = "font-extrabold text-2xl uppercase my-2", "Top/Bottom content"),
  spacer(y = 2),
  table(
    iris[1:5, ],
    isCompact = TRUE,
    topContent = div(
      class = "flex justify-between",
      p("Top content ..."),
      chip("My chip"),
      badge(
        button("CLick me"),
        color = "success",
        placement = "top-right",
        content = "New"
      )
    ),
    bottomContent = div(
      class = "flex justify-between",
      p("Bottom content ..."),
      link(
        href = "https://heroui.com/docs/components/table",
        target = "_blank",
        "To the doc."
      )
    )
  )
)

server <- function(input, output, session) {
}

if (interactive() || is_testing()) shinyApp(ui, server)
