/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Entity;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.FieldUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.ScalarLabelUtil;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.XMLUtil;

public class ModelUtil {
    private static final Pattern FUNCTION_INVOCATION = Pattern.compile("^(.+)\\((.+)\\)$");

    private ModelUtil() {
    }

    public static MathContext simplifyMathContext(MathContext mathContext) {
        return mathContext == MathContext.DOUBLE ? null : mathContext;
    }

    public static MiningSchema createMiningSchema(Label label) {
        MiningSchema miningSchema = new MiningSchema();
        if (label != null) {
            List<ScalarLabel> scalarLabels = ScalarLabelUtil.toScalarLabels(label);
            for (ScalarLabel scalarLabel : scalarLabels) {
                if (scalarLabel.isAnonymous()) continue;
                MiningField miningField = ModelUtil.createMiningField(scalarLabel.getName(), MiningField.UsageType.TARGET);
                miningSchema.addMiningFields(new MiningField[]{miningField});
            }
        }
        return miningSchema;
    }

    public static MiningField createMiningField(String name) {
        return ModelUtil.createMiningField(name, null);
    }

    public static MiningField createMiningField(String name, MiningField.UsageType usageType) {
        MiningField miningField = new MiningField(name).setUsageType(usageType);
        return miningField;
    }

    public static Targets createRescaleTargets(Number slope, Number intercept, ContinuousLabel continuousLabel) {
        Target target = new Target().setTargetField(continuousLabel.getName());
        boolean rescaled = false;
        if (slope != null && !ValueUtil.isOne(slope)) {
            target.setRescaleFactor(slope);
            rescaled = true;
        }
        if (intercept != null && !ValueUtil.isZeroLike(intercept)) {
            target.setRescaleConstant(intercept);
            rescaled = true;
        }
        if (!rescaled) {
            return null;
        }
        Targets targets = new Targets().addTargets(new Target[]{target});
        return targets;
    }

    public static Output ensureOutput(Model model) {
        Output output = model.getOutput();
        if (output == null) {
            output = new Output();
            model.setOutput(output);
        }
        return output;
    }

    public static Output createPredictedOutput(String name, OpType opType, DataType dataType, Transformation ... transformations) {
        Output output = new Output();
        OutputField outputField = ModelUtil.createPredictedField(name, opType, dataType).setFinalResult(Boolean.valueOf(false));
        output.addOutputFields(new OutputField[]{outputField});
        for (Transformation transformation : transformations) {
            outputField = transformation.createOutputField(outputField);
            output.addOutputFields(new OutputField[]{outputField});
        }
        return output;
    }

    public static Output createProbabilityOutput(MathContext mathContext, DiscreteLabel discreteLabel) {
        DataType dataType = DataType.DOUBLE;
        if (mathContext == MathContext.FLOAT) {
            dataType = DataType.FLOAT;
        }
        return ModelUtil.createProbabilityOutput(dataType, discreteLabel);
    }

    public static Output createProbabilityOutput(DataType dataType, DiscreteLabel discreteLabel) {
        Output output = new Output();
        List outputFields = output.getOutputFields();
        outputFields.addAll(ModelUtil.createProbabilityFields(dataType, discreteLabel.getValues()));
        return output;
    }

    public static Output createNeighborOutput(int count) {
        Output output = new Output();
        List outputFields = output.getOutputFields();
        outputFields.addAll(ModelUtil.createNeighborFields(count));
        return output;
    }

    public static OutputField createAffinityField(DataType dataType, Object value) {
        return ModelUtil.createAffinityField(FieldNameUtil.create("affinity", value), dataType, value);
    }

    public static OutputField createAffinityField(String name, DataType dataType, Object value) {
        OutputField outputField = new OutputField(name, OpType.CONTINUOUS, dataType).setResultFeature(ResultFeature.AFFINITY).setValue(value);
        return outputField;
    }

    public static List<OutputField> createAffinityFields(DataType dataType, List<? extends Entity<?>> entities) {
        return entities.stream().map(entity -> ModelUtil.createAffinityField(dataType, entity.getId())).collect(Collectors.toList());
    }

    public static OutputField createEntityIdField(String name, DataType dataType) {
        OutputField outputField = new OutputField(name, OpType.CATEGORICAL, dataType).setResultFeature(ResultFeature.ENTITY_ID);
        return outputField;
    }

    public static OutputField createEntityIdField(String name, DataType dataType, List<?> values) {
        OutputField outputField = ModelUtil.createEntityIdField(name, dataType);
        if (values != null && !values.isEmpty()) {
            FieldUtil.addValues(outputField, values);
        }
        return outputField;
    }

    public static OutputField createPredictedField(String name, OpType opType, DataType dataType) {
        OutputField outputField = new OutputField(name, opType, dataType).setResultFeature(ResultFeature.PREDICTED_VALUE);
        return outputField;
    }

    public static OutputField createPredictedField(String name, OpType opType, DataType dataType, List<?> values) {
        OutputField outputField = ModelUtil.createPredictedField(name, opType, dataType);
        if (values != null && !values.isEmpty()) {
            FieldUtil.addValues(outputField, values);
        }
        return outputField;
    }

    public static OutputField createProbabilityField(DataType dataType, Object value) {
        return ModelUtil.createProbabilityField(FieldNameUtil.create("probability", value), dataType, value);
    }

    public static OutputField createProbabilityField(String name, DataType dataType, Object value) {
        OutputField outputField = new OutputField(name, OpType.CONTINUOUS, dataType).setResultFeature(ResultFeature.PROBABILITY).setValue(value);
        return outputField;
    }

    public static List<OutputField> createProbabilityFields(DataType dataType, List<?> values) {
        return values.stream().map(value -> ModelUtil.createProbabilityField(dataType, value)).collect(Collectors.toList());
    }

    public static OutputField createNeighborField(DataType dataType, int rank) {
        OutputField outputField = new OutputField(FieldNameUtil.create("neighbor", rank), OpType.CATEGORICAL, dataType).setResultFeature(ResultFeature.ENTITY_ID).setRank(Integer.valueOf(rank));
        return outputField;
    }

    public static List<OutputField> createNeighborFields(int count) {
        ArrayList<OutputField> result = new ArrayList<OutputField>();
        for (int i = 0; i < count; ++i) {
            result.add(ModelUtil.createNeighborField(DataType.STRING, i + 1));
        }
        return result;
    }

    public static ModelStats ensureModelStats(Model model) {
        ModelStats modelStats = model.getModelStats();
        if (modelStats == null) {
            modelStats = new ModelStats();
            model.setModelStats(modelStats);
        }
        return modelStats;
    }

    public static VerificationField createVerificationField(String name) {
        Object tagName = name;
        Matcher matcher = FUNCTION_INVOCATION.matcher((CharSequence)tagName);
        if (matcher.matches()) {
            tagName = matcher.group(1) + "_" + matcher.group(2);
        }
        String column = "data:" + XMLUtil.createTagName((String)tagName);
        VerificationField verificationField = new VerificationField(name, column);
        return verificationField;
    }

    public static ModelVerification createModelVerification(Map<VerificationField, List<?>> data) {
        VerificationFields verificationFields = new VerificationFields().addVerificationFields((VerificationField[])Iterables.toArray(data.keySet(), VerificationField.class));
        InlineTable inlineTable = PMMLUtil.createInlineTable(VerificationField::getColumn, data);
        List rows = inlineTable.getRows();
        ModelVerification modelVerification = new ModelVerification(verificationFields, inlineTable).setRecordCount(Integer.valueOf(rows.size()));
        return modelVerification;
    }
}

