/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.Objects;
import org.dmg.pmml.DataType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.model.ToStringHelper;

public class ConstantFeature
extends Feature
implements HasDerivedName {
    private Number value = null;

    public ConstantFeature(PMMLEncoder encoder, Number value) {
        this(encoder, value.toString() + (value instanceof Float ? "f" : ""), TypeUtil.getDataType(value), value);
    }

    public ConstantFeature(PMMLEncoder encoder, String name, DataType dataType, Number value) {
        super(encoder, name, dataType);
        this.setValue(value);
    }

    @Override
    public String getDerivedName() {
        return FieldNameUtil.create("constant", this.getName());
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        return this.toContinuousFeature(this.getDerivedName(), this.getDataType(), () -> ExpressionUtil.createConstant(this.getDataType(), this.getValue()));
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConstantFeature) {
            ConstantFeature that = (ConstantFeature)object;
            return super.equals(object) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("value", (Object)this.getValue());
    }

    public Number getValue() {
        return this.value;
    }

    private void setValue(Number value) {
        this.value = Objects.requireNonNull(value);
    }
}

