# Licensing Information for `MedxR` Package

This package, `MedxR`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **caffeine_matrix**: 
  Originally caffeine from the msos 1.2.0 package, licensed under MIT + file LICENSE. The dataset name has been changed to 'caffeine_matrix' to indicate that this dataset is a matrix object.

- **histamine_matrix**: 
  Originally histamine from the msos 1.2.0 package, licensed under MIT + file LICENSE. The dataset name has been changed to 'histamine_matrix' to indicate that this dataset is a matrix object.    

- **dosage_tbl_df**: 
  Originally dosage from the AMR 3.0.0 package, licensed under GPL-2 | file LICENSE. The dataset name has been changed to 'dosage_tbl_df' to indicate that this dataset is a tibble object.   

- **binding_df**: 
  Originally binding from the isdals 3.0.1 package, licensed under GPL-2. The dataset name has been changed to 'binding_df' to indicate that this dataset is a data frame object.     

- **naoh_digest_df**: 
  Originally digestcoefs from the isdals 3.0.1 package, licensed under GPL-2. The dataset name has been changed to 'naoh_digest_df' to indicate that this dataset is a data frame object.   

- **oilvitaminA_df**: 
  Originally oilvit from the isdals 3.0.1 package, licensed under GPL-2. The dataset name has been changed to 'oilvitaminA_df' to indicate that this dataset is a data frame object.   

- **ratliver_df**: 
  Originally ratliver from the isdals 3.0.1 package, licensed under GPL-2. The dataset name has been changed to 'ratliver_df' to indicate that this dataset is a data frame object.   

- **drug_prices_tbl_df**: 
  Originally Prices_Drug from the covid19dbcand 0.1.1 package, licensed under CC0. The dataset name has been changed to 'drug_prices_tbl_df' to indicate that this dataset is a tibble object.   

- **products_drug_tbl_df**: 
  Originally Products_Drug from the covid19dbcand 0.1.1 package, licensed under CC0. The dataset name has been changed to 'products_drug_tbl_df' to indicate that this dataset is a tibble object.   

- **reactions_drug_tbl_df**: 
  Originally Reactions_Drug from the covid19dbcand 0.1.1 package, licensed under CC0. The dataset name has been changed to 'reactions_drug_tbl_df' to indicate that this dataset is a tibble object.  

- **ATC_code_tbl_df**: 
  Originally ATC_Codes_Drug from the covid19dbcand 0.1.1 package, licensed under CC0. The dataset name has been changed to 'ATC_code_tbl_df' to indicate that this dataset is a tibble object.  

- **pharmacy_tbl_df**: 
  Originally pharmacy from the idarps 0.0.5 package, licensed under AGPL-3. The dataset name has been changed to 'pharmacy_tbl_df' to indicate that this dataset is a tibble object.  

- **placebos_df**: 
  Originally Placebos from the SRMData 1.0.1 package, licensed under GPL (>= 2). The dataset name has been changed to 'placebos_df' to indicate that this dataset is a data frame object.   

- **drugsmisuse_tbl_df**: 
  Originally drugs from the lay 0.1.3 package, licensed under MIT + file LICENSE. The dataset name has been changed to 'drugsmisuse_tbl_df' to indicate that this dataset is a tibble object.   

- **BCG_vaccine_df**: 
  Originally dat.bcg from the metadat 1.4-0 package, licensed under GPL (>= 2). The dataset name has been changed to 'BCG_vaccine_df' to indicate that this dataset is a data frame object.   

- **oral_anticoagulants_df**: 
  Originally dat.anand1999 from the metadat 1.4-0 package, licensed under GPL (>= 2). The dataset name has been changed to 'oral_anticoagulants_df' to indicate that this dataset is a data frame object.   

- **copd_drug_therapy_df**: 
  Originally dat.baker2009 from the metadat 1.4-0 package, licensed under GPL (>= 2). The dataset name has been changed to 'copd_drug_therapy_df' to indicate that this dataset is a data frame object.   

- **aspirin_infarction_df**: 
  Originally Fleiss1993bin from the meta 8.0-2 package, licensed under GPL (>= 2). The dataset name has been changed to 'aspirin_infarction_df' to indicate that this dataset is a data frame object.  

- **parkinsons_list**: 
  Originally parkinsons from the bnma 1.6.0 package, licensed under GPL-3. The dataset name has been changed to 'parkinsons_list' to indicate that this dataset is a list object.   


## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `MedxR`, is licensed under the GPL-3 License.
