/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SingleDate
implements Holiday {
    private final LocalDate date;
    private final double weight;

    public SingleDate(LocalDate date, double weight) {
        this.date = date;
        this.weight = weight;
    }

    @Override
    public SingleDate reweight(double nweight) {
        if (this.weight == this.weight) {
            return this;
        }
        return new SingleDate(this.date, nweight);
    }

    @Override
    public String display() {
        return this.date.format(DateTimeFormatter.ISO_DATE);
    }

    @Override
    public ValidityPeriod getValidityPeriod() {
        return ValidityPeriod.ALWAYS;
    }

    @Override
    public Holiday forPeriod(LocalDate start, LocalDate end) {
        return this;
    }

    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Override
    @Generated
    public double getWeight() {
        return this.weight;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleDate)) {
            return false;
        }
        SingleDate other = (SingleDate)o;
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SingleDate(date=" + String.valueOf(this.getDate()) + ", weight=" + this.getWeight() + ")";
    }
}

