/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.regarima;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.outlier.CriticalValueComputer;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import lombok.Generated;

public final class DemetraUtility {
    public static final double MINCV = 2.8;

    public static double calcCv(int nobs) {
        return Math.max(CriticalValueComputer.simpleComputer().applyAsDouble(nobs), 2.8);
    }

    public static IRegArimaComputer<SarimaModel> processor(boolean ml, double precision) {
        return RegSarimaComputer.builder().useMaximumLikelihood(ml).precision(precision).startingPoint(RegSarimaComputer.StartingPoint.Multiple).build();
    }

    public static int autlar(int n, SarimaOrders spec) {
        int d = spec.getD() + spec.getPeriod() * spec.getBd();
        int q = spec.getQ() + spec.getPeriod() * spec.getBq();
        int p = spec.getP() + spec.getPeriod() * spec.getBp();
        int nd = n - d;
        int nar = (int)Math.log(nd * nd);
        int m = Math.max(p, 2 * q);
        if (m > nar) {
            nar = m;
        }
        if (nar >= nd) {
            nar = nd - nd / 4;
        }
        if (nar > 50) {
            nar = 50;
        }
        int ncol = spec.getP() + (1 + spec.getP()) * spec.getBp() + spec.getQ() + (1 + spec.getQ()) * spec.getBq();
        return nd - nar - Math.max(p, q) - ncol;
    }

    @Generated
    private DemetraUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

