/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.bayes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class BayesRegularizedRegressionResults {
    private final List<Result> samples;

    @Generated
    BayesRegularizedRegressionResults(List<Result> samples) {
        this.samples = samples;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public List<Result> getSamples() {
        return this.samples;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BayesRegularizedRegressionResults)) {
            return false;
        }
        BayesRegularizedRegressionResults other = (BayesRegularizedRegressionResults)o;
        List<Result> this$samples = this.getSamples();
        List<Result> other$samples = other.getSamples();
        return !(this$samples == null ? other$samples != null : !((Object)this$samples).equals(other$samples));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Result> $samples = this.getSamples();
        result = result * 59 + ($samples == null ? 43 : ((Object)$samples).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "BayesRegularizedRegressionResults(samples=" + String.valueOf(this.getSamples()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private ArrayList<Result> samples;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder sample(Result sample) {
            if (this.samples == null) {
                this.samples = new ArrayList();
            }
            this.samples.add(sample);
            return this;
        }

        @Generated
        public @NonNull Builder samples(@NonNull Collection<? extends Result> samples) {
            if (samples == null) {
                throw new NullPointerException("samples cannot be null");
            }
            if (this.samples == null) {
                this.samples = new ArrayList();
            }
            this.samples.addAll(samples);
            return this;
        }

        @Generated
        public @NonNull Builder clearSamples() {
            if (this.samples != null) {
                this.samples.clear();
            }
            return this;
        }

        @Generated
        public @NonNull BayesRegularizedRegressionResults build() {
            return new BayesRegularizedRegressionResults(switch (this.samples == null ? 0 : this.samples.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.samples.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Result>(this.samples));
            });
        }

        @Generated
        public @NonNull String toString() {
            return "BayesRegularizedRegressionResults.Builder(samples=" + String.valueOf(this.samples) + ")";
        }
    }

    public static final class Result {
        private final DoubleSeq b;
        private final double b0;
        private final double tau2;

        @Generated
        public Result(DoubleSeq b, double b0, double tau2) {
            this.b = b;
            this.b0 = b0;
            this.tau2 = tau2;
        }

        @Generated
        public DoubleSeq getB() {
            return this.b;
        }

        @Generated
        public double getB0() {
            return this.b0;
        }

        @Generated
        public double getTau2() {
            return this.tau2;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (Double.compare(this.getB0(), other.getB0()) != 0) {
                return false;
            }
            if (Double.compare(this.getTau2(), other.getTau2()) != 0) {
                return false;
            }
            DoubleSeq this$b = this.getB();
            DoubleSeq other$b = other.getB();
            return !(this$b == null ? other$b != null : !this$b.equals(other$b));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $b0 = Double.doubleToLongBits(this.getB0());
            result = result * 59 + (int)($b0 >>> 32 ^ $b0);
            long $tau2 = Double.doubleToLongBits(this.getTau2());
            result = result * 59 + (int)($tau2 >>> 32 ^ $tau2);
            DoubleSeq $b = this.getB();
            result = result * 59 + ($b == null ? 43 : $b.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "BayesRegularizedRegressionResults.Result(b=" + String.valueOf(this.getB()) + ", b0=" + this.getB0() + ", tau2=" + this.getTau2() + ")";
        }
    }
}

