/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaMenuPainterClient;
import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.View;

public class QuaquaMenuPainter {
    private static QuaquaMenuPainter instance;
    static final int defaultMenuItemGap = 2;
    static final int kAcceleratorArrowSpace = 0;
    static final int kAcceleratorArrowMargin = 20;
    static final Rectangle zeroRect;
    static final Rectangle iconRect;
    static final Rectangle textRect;
    static final Rectangle acceleratorRect;
    static final Rectangle checkIconRect;
    static final Rectangle arrowIconRect;
    static final Rectangle viewRect;
    static Rectangle r;
    private PlaceholderIcon placeholderIcon = new PlaceholderIcon();

    public static QuaquaMenuPainter getInstance() {
        if (instance == null) {
            instance = new QuaquaMenuPainter();
        }
        return instance;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    private Dimension getMinimumIconSize(Container parent) {
        Dimension d = new Dimension();
        Component[] c = parent.getComponents();
        for (int i = 0; i < c.length; ++i) {
            AbstractButton b;
            Icon icon;
            if (!(c[i] instanceof AbstractButton) || (icon = (b = (AbstractButton)c[i]).getIcon()) == null) continue;
            d.width = Math.max(d.width, icon.getIconWidth());
            d.height = Math.max(d.height, icon.getIconHeight());
        }
        return d;
    }

    protected void paintMenuItem(QuaquaMenuPainterClient client, Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, Color disabledForeground, Color selectionForeground, int textIconGap, Font acceleratorFont) {
        boolean isEnabled;
        Container container;
        Object oldHints = QuaquaUtilities.beginGraphics((Graphics2D)g);
        JMenuItem menuItem = (JMenuItem)c;
        ButtonModel buttonModel = menuItem.getModel();
        int width = menuItem.getWidth();
        int height = menuItem.getHeight();
        Insets insets = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, width, height);
        QuaquaMenuPainter.viewRect.x += insets.left;
        QuaquaMenuPainter.viewRect.y += insets.top;
        QuaquaMenuPainter.viewRect.width -= insets.right + QuaquaMenuPainter.viewRect.x;
        QuaquaMenuPainter.viewRect.height -= insets.bottom + QuaquaMenuPainter.viewRect.y;
        Font savedFont = g.getFont();
        Color savedColor = g.getColor();
        Font textFont = c.getFont();
        g.setFont(textFont);
        FontMetrics textFM = g.getFontMetrics(textFont);
        FontMetrics acceleratorFM = g.getFontMetrics(acceleratorFont);
        if (c.isOpaque()) {
            client.paintBackground(g, c, width, height);
        }
        KeyStroke accelerator = menuItem.getAccelerator();
        String modifiersText = "";
        String acceleratorKeyText = "";
        boolean isLeftToRight = QuaquaUtilities.isLeftToRight(c);
        if (accelerator != null) {
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                modifiersText = QuaquaUtilities.getKeyModifiersText(modifiers, isLeftToRight);
            }
            acceleratorKeyText = this.getAcceleratorKeyText(accelerator);
        }
        String clippedText = this.layoutMenuItem(menuItem, textFM, menuItem.getText(), acceleratorFM, acceleratorKeyText, modifiersText, menuItem.getIcon(), checkIcon, arrowIcon, menuItem.getVerticalAlignment(), menuItem.getHorizontalAlignment(), menuItem.getVerticalTextPosition(), menuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, menuItem.getText() == null ? 0 : textIconGap, textIconGap);
        for (container = menuItem.getParent(); container != null && !(container instanceof JPopupMenu); container = container.getParent()) {
        }
        boolean bl = isEnabled = buttonModel.isEnabled() && (container == null || container.isVisible());
        if (menuItem.getIcon() != null) {
            this.paintIcon(g, c, iconRect, isEnabled);
        }
        boolean isSelected = false;
        if (!isEnabled) {
            g.setColor(disabledForeground);
        } else if (buttonModel.isArmed() || c instanceof JMenu && buttonModel.isSelected()) {
            g.setColor(selectionForeground);
            isSelected = true;
        } else {
            g.setColor(menuItem.getForeground());
        }
        if (checkIcon != null) {
            this.paintCheck(g, c, checkIcon);
        }
        if (acceleratorKeyText != null && !acceleratorKeyText.equals("")) {
            int baseline = QuaquaMenuPainter.acceleratorRect.y + textFM.getAscent();
            if (modifiersText.equals("")) {
                g.drawString(acceleratorKeyText, QuaquaMenuPainter.acceleratorRect.x, baseline);
            } else {
                int modifiers = accelerator.getModifiers();
                int mnemonicChar = 0;
                if ((modifiers & 0x20) > 0) {
                    mnemonicChar = 8997;
                }
                int acceleratorKeyWidth = Math.max(textFM.charWidth('M'), SwingUtilities.computeStringWidth(textFM, acceleratorKeyText));
                if (isLeftToRight) {
                    g.setFont(acceleratorFont);
                    this.drawString(client, g, modifiersText, mnemonicChar, QuaquaMenuPainter.acceleratorRect.x, baseline, isEnabled, isSelected);
                    g.setFont(textFont);
                    g.drawString(acceleratorKeyText, QuaquaMenuPainter.acceleratorRect.x + QuaquaMenuPainter.acceleratorRect.width - 0 - acceleratorKeyWidth, baseline);
                } else {
                    int x = QuaquaMenuPainter.acceleratorRect.x + 0 + acceleratorKeyWidth;
                    g.setFont(acceleratorFont);
                    this.drawString(client, g, modifiersText, mnemonicChar, x, baseline, isEnabled, isSelected);
                    g.setFont(textFont);
                    g.drawString(acceleratorKeyText, x - textFM.stringWidth(acceleratorKeyText), baseline);
                }
            }
        }
        if (clippedText != null && !clippedText.equals("")) {
            View view = (View)c.getClientProperty("html");
            if (view != null) {
                view.paint(g, textRect);
            } else {
                this.drawString(client, g, clippedText, buttonModel.getMnemonic(), QuaquaMenuPainter.textRect.x, QuaquaMenuPainter.textRect.y + textFM.getAscent(), isEnabled, isSelected);
            }
        }
        if (arrowIcon != null) {
            if (buttonModel.isArmed() || c instanceof JMenu && buttonModel.isSelected()) {
                g.setColor(foreground);
            }
            if (this.useCheckAndArrow(menuItem)) {
                arrowIcon.paintIcon(c, g, QuaquaMenuPainter.arrowIconRect.x, QuaquaMenuPainter.arrowIconRect.y);
            }
        }
        g.setColor(savedColor);
        g.setFont(savedFont);
        QuaquaUtilities.endGraphics((Graphics2D)g, oldHints);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int textIconGap, Font acceleratorFont) {
        Insets insets;
        boolean isUseCheckAndArrow;
        boolean hasNoAccelerator;
        JMenuItem menuItem = (JMenuItem)c;
        Icon icon = menuItem.getIcon();
        String text = menuItem.getText();
        KeyStroke accelerator = menuItem.getAccelerator();
        String acceleratorKeyText = "";
        String modifiersText = "";
        if (accelerator != null) {
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                modifiersText = QuaquaUtilities.getKeyModifiersText(modifiers, true);
            }
            acceleratorKeyText = this.getAcceleratorKeyText(accelerator);
        }
        Font textFont = menuItem.getFont();
        FontMetrics textFM = menuItem.getFontMetrics(textFont);
        FontMetrics acceleratorFM = menuItem.getFontMetrics(acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(menuItem, textFM, text, acceleratorFM, acceleratorKeyText, modifiersText, icon, checkIcon, arrowIcon, menuItem.getVerticalAlignment(), menuItem.getHorizontalAlignment(), menuItem.getVerticalTextPosition(), menuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : textIconGap, textIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(QuaquaMenuPainter.iconRect.x, QuaquaMenuPainter.iconRect.y, QuaquaMenuPainter.iconRect.width, QuaquaMenuPainter.iconRect.height, r);
        boolean bl = hasNoAccelerator = acceleratorKeyText == null || acceleratorKeyText.equals("");
        if (!hasNoAccelerator) {
            QuaquaMenuPainter.r.width += QuaquaMenuPainter.acceleratorRect.width + 20;
        }
        if (isUseCheckAndArrow = this.useCheckAndArrow(menuItem)) {
            QuaquaMenuPainter.r.width += QuaquaMenuPainter.checkIconRect.width;
            QuaquaMenuPainter.r.width += textIconGap;
            if (QuaquaMenuPainter.arrowIconRect.width + 20 > QuaquaMenuPainter.acceleratorRect.width) {
                QuaquaMenuPainter.r.width += QuaquaMenuPainter.arrowIconRect.width + 20 - QuaquaMenuPainter.acceleratorRect.width;
            }
        }
        if ((insets = menuItem.getInsets()) != null) {
            QuaquaMenuPainter.r.width += insets.left + insets.right;
            QuaquaMenuPainter.r.height += insets.top + insets.bottom;
        }
        if ((insets = isUseCheckAndArrow ? UIManager.getInsets("Menu.margin") : UIManager.getInsets("MenuBar.margin")) != null) {
            QuaquaMenuPainter.r.width += insets.left + insets.right;
            QuaquaMenuPainter.r.height += insets.top + insets.bottom;
        }
        return r.getSize();
    }

    protected void paintCheck(Graphics g, JComponent c, Icon checkIcon) {
        if (this.useCheckAndArrow((JMenuItem)c)) {
            checkIcon.paintIcon(c, g, QuaquaMenuPainter.checkIconRect.x, QuaquaMenuPainter.checkIconRect.y);
        }
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle rectangle, boolean isEnabled) {
        Icon icon;
        AbstractButton abstractButton = (AbstractButton)c;
        ButtonModel buttonModel = abstractButton.getModel();
        if (!isEnabled) {
            icon = abstractButton.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon = abstractButton.getPressedIcon();
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
        } else {
            icon = abstractButton.getIcon();
        }
        if (icon != null) {
            icon.paintIcon(c, g, rectangle.x, rectangle.y);
        }
    }

    public void drawString(QuaquaMenuPainterClient client, Graphics g, String text, int mnemonicChar, int x, int y, boolean isEnabled, boolean isSelected) {
        int mnemonicPos = -1;
        if (mnemonicChar != 0) {
            char mnemonicUpperCase = Character.toUpperCase((char)mnemonicChar);
            char mnemonicLowerCase = Character.toLowerCase((char)mnemonicChar);
            int upperCasePos = text.indexOf(mnemonicUpperCase);
            int lowerCasePos = text.indexOf(mnemonicLowerCase);
            mnemonicPos = upperCasePos == -1 ? lowerCasePos : (lowerCasePos == -1 ? upperCasePos : (lowerCasePos < upperCasePos ? lowerCasePos : upperCasePos));
        }
        g.drawString(text, x, y);
        if (mnemonicPos != -1) {
            FontMetrics fm = g.getFontMetrics();
            int underlineX = x + fm.stringWidth(text.substring(0, mnemonicPos));
            int underlineY = y;
            int underlineWidth = fm.charWidth(text.charAt(mnemonicPos));
            int underlineHeight = 1;
            g.fillRect(underlineX, underlineY + fm.getDescent() - 1, underlineWidth, underlineHeight);
        }
    }

    private boolean useCheckAndArrow(JMenuItem menuItem) {
        return !(menuItem instanceof JMenu) || !((JMenu)menuItem).isTopLevelMenu();
    }

    private String layoutMenuItem(JMenuItem menuItem, FontMetrics textFM, String text, FontMetrics acceleratorFM, String acceleratorKeyText, String modifiersText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int textCheckIconGap) {
        Insets margin;
        boolean hasNoAccelerator;
        if (menuItem.getParent() != null) {
            this.placeholderIcon.dim = this.getMinimumIconSize(menuItem.getParent());
            icon = this.placeholderIcon.getIconWidth() == 0 ? null : this.placeholderIcon;
        }
        SwingUtilities.layoutCompoundLabel(menuItem, textFM, text, icon, 1, 2, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        boolean bl = hasNoAccelerator = acceleratorKeyText == null || acceleratorKeyText.equals("");
        if (hasNoAccelerator) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorKeyText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(acceleratorFM, modifiersText) + 0;
            acceleratorRect.width += Math.max(textFM.charWidth('M'), SwingUtilities.computeStringWidth(textFM, acceleratorKeyText));
            acceleratorRect.height = acceleratorFM.getHeight();
        }
        boolean isUseCheckAndArrow = this.useCheckAndArrow(menuItem);
        if (isUseCheckAndArrow) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
                textRect.x += checkIconRect.width + textCheckIconGap;
                iconRect.x += checkIconRect.width + textCheckIconGap;
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        acceleratorRect.x = viewRect.width - acceleratorRect.width;
        acceleratorRect.y = textRect.y;
        if (isUseCheckAndArrow) {
            arrowIconRect.x = viewRect.width - arrowIconRect.width;
            arrowIconRect.y = viewRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = viewRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        if (!QuaquaUtilities.isLeftToRight(menuItem)) {
            int width = viewRect.width;
            checkIconRect.x = width - (checkIconRect.x + checkIconRect.width);
            iconRect.x = width - (iconRect.x + iconRect.width);
            textRect.x = width - (textRect.x + textRect.width);
            acceleratorRect.x = width - (acceleratorRect.x + acceleratorRect.width);
            arrowIconRect.x = width - (arrowIconRect.x + arrowIconRect.width);
        }
        if ((margin = isUseCheckAndArrow ? UIManager.getInsets("Menu.margin") : UIManager.getInsets("MenuBar.margin")) != null) {
            checkIconRect.x += margin.left;
            checkIconRect.y += margin.top;
            iconRect.x += margin.left;
            iconRect.y += margin.top;
            textRect.x += margin.left;
            textRect.y += margin.top;
            acceleratorRect.x -= margin.right;
            acceleratorRect.y += margin.top;
            arrowIconRect.x -= margin.right;
            arrowIconRect.y += margin.top;
        }
        return text;
    }

    private String getAcceleratorKeyText(KeyStroke accelerator) {
        StringBuffer buf = new StringBuffer();
        if (accelerator != null) {
            int keyCode = accelerator.getKeyCode();
            if (keyCode != 0) {
                switch (keyCode) {
                    case 10: {
                        buf.append('\u21a9');
                        break;
                    }
                    case 8: {
                        buf.append('\u232b');
                        break;
                    }
                    case 127: {
                        buf.append('\u2326');
                        break;
                    }
                    case 38: {
                        buf.append('\u2191');
                        break;
                    }
                    case 40: {
                        buf.append('\u2193');
                        break;
                    }
                    case 37: {
                        buf.append('\u2190');
                        break;
                    }
                    case 39: {
                        buf.append('\u2192');
                        break;
                    }
                    case 521: {
                        buf.append('+');
                        break;
                    }
                    case 45: {
                        buf.append('-');
                        break;
                    }
                    default: {
                        buf.append(KeyEvent.getKeyText(keyCode));
                        break;
                    }
                }
            } else {
                buf.append(accelerator.getKeyChar());
            }
        }
        return buf.toString();
    }

    static {
        zeroRect = new Rectangle(0, 0, 0, 0);
        iconRect = new Rectangle();
        textRect = new Rectangle();
        acceleratorRect = new Rectangle();
        checkIconRect = new Rectangle();
        arrowIconRect = new Rectangle();
        viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        r = new Rectangle();
    }

    private static class PlaceholderIcon
    implements Icon {
        public Dimension dim;
        public Container parent;

        private PlaceholderIcon() {
        }

        public int getIconHeight() {
            return this.dim.height;
        }

        public int getIconWidth() {
            return this.dim.width;
        }

        public void paintIcon(Component component, Graphics graphics, int param, int param3) {
        }
    }
}

