/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.extractors;

import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.core.stats.likelihood.DiffuseLikelihoodStatistics;

public class DiffuseLikelihoodStatisticsExtractor
extends InformationMapping<DiffuseLikelihoodStatistics> {
    public DiffuseLikelihoodStatisticsExtractor() {
        this.set("ll", Double.class, source -> source.getLogLikelihood());
        this.set("adjustedll", Double.class, source -> source.getAdjustedLogLikelihood());
        this.set("ssqerr", Double.class, source -> source.getSsqErr());
        this.set("nparams", Integer.class, source -> source.getEstimatedParametersCount());
        this.set("nobs", Integer.class, source -> source.getObservationsCount());
        this.set("ndiffuse", Integer.class, source -> source.getDiffuseCount());
        this.set("df", Integer.class, source -> source.getObservationsCount() - source.getEstimatedParametersCount() - source.getDiffuseCount());
        this.set("aic", Double.class, source -> source.aic());
        this.set("aicc", Double.class, source -> source.aicc());
        this.set("bic", Double.class, source -> source.bic());
        this.set("hannanquinn", Double.class, source -> source.hannanQuinn());
    }

    public Class getSourceClass() {
        return DiffuseLikelihoodStatistics.class;
    }
}

