## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height= 5
)

## ----loadData-----------------------------------------------------------------
library(pscDesign)
library(psc)
gemCFM <- pscDesign::gemCFM

## ----singleFit----------------------------------------------------------------
simData <- dataSim(gemCFM,n0=0,n1=500,beta=log(0.5),fuTime=12,recTime=24)
psc.ex <- pscfit(gemCFM,simData)


## ----singleFitSumm------------------------------------------------------------
summary(psc.ex)
plot(psc.ex)

## ----singleArmRec-------------------------------------------------------------
N.site <- 4
rpm <- 0.88
open.rate <- 1
recTime <- 24
recF <- recForcast(N.site,rpm,open.rate,Max.Time=recTime)  

## ----singleArm,echo=T,results='hide'------------------------------------------
pscDes_singArm <- pscDesign(CFM=gemCFM,n0=0,n1=70,beta=log(0.7),rec=recF,
                                fuTime=12,nsim=10,nsim.psc=750,burn.psc=250,
                                bound=0,direction="greater",
                                alpha_eval=c(0.05,0.1,0.15,0.2))

## ----singleArmRes-------------------------------------------------------------
pscDes_singArm

## ----randRec------------------------------------------------------------------
N.site <- 4
rpm <- 0.88
open.rate <- 1
recTime <- 30
recF <- recForcast(N.site,rpm,open.rate,Max.Time=recTime)  #100 patients over 30 months

## ----randArm,echo=T,results='hide'--------------------------------------------
pscDes_rand <- pscDesign(CFM=gemCFM,n0=30,n1=70,beta=log(0.7),rec=recF,
                                fuTime=12,nsim=5,nsim.psc=750,burn.psc=250,
                                bound=0,direction="greater",
                                alpha_eval=c(0.05,0.1,0.15,0.2))

## ----randArmRes---------------------------------------------------------------
pscDes_rand

