/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regsarima.regular.IAutoModellingModule;
import jdplus.toolkit.base.core.regsarima.regular.ILogLevelModule;
import jdplus.toolkit.base.core.regsarima.regular.IModelBuilder;
import jdplus.toolkit.base.core.regsarima.regular.IOutliersDetectionModule;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaProcessor;
import jdplus.toolkit.base.core.regsarima.regular.RegressionVariablesTest;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.x13.base.api.regarima.RegArimaSpec;
import jdplus.x13.base.core.x13.regarima.DefaultModelBuilder;
import jdplus.x13.base.core.x13.regarima.FinalEstimator;
import jdplus.x13.base.core.x13.regarima.MeanController;
import jdplus.x13.base.core.x13.regarima.ModelController;
import jdplus.x13.base.core.x13.regarima.X13SpecDecoder;
import jdplus.x13.base.core.x13.regarima.X13Utility;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public class RegArimaKernel
implements RegSarimaProcessor {
    private static final String REGARIMA = "regarima";
    private static final String LAST_CHANCE = "last chance model";
    private static final String OUTLIERS_VA_REDUCED = "reduction of the critical value for outliers detection";
    private static final String AMI = "automatic model identification";
    private static final String ROUND = "round ";
    private static final String LOGNEG = "can't apply log transformation 'some obs. are <= 0";
    private static final double FCT = 1.0126582278481011;
    private static final double FCT2 = 1.0;
    private static final double MALIM = 0.001;
    private static final double MINCV = 2.8;
    private static final int MAXD = 2;
    private static final int MAXBD = 1;
    private final IModelBuilder modelBuilder;
    private final ILogLevelModule transformation;
    private final IRegressionModule calendarTest;
    private final IRegressionModule easterTest;
    private final IOutliersDetectionModule outliers;
    private final AmiOptions options;
    private final IAutoModellingModule autoModel;
    private final RegressionVariablesTest regressionTest0;
    private final RegressionVariablesTest regressionTest1;
    private final FinalEstimator finalEstimator;
    private double va0 = 0.0;
    private double curva = 0.0;
    private double pcr;
    private RegSarimaModelling reference;
    private boolean needOutliers;
    private boolean needAutoModelling;
    private int loop;
    private int round;
    private double plbox0;
    private double rvr0;
    private double rtval0;

    public static Builder builder() {
        return new Builder();
    }

    public static RegArimaKernel of(RegArimaSpec spec, ModellingContext context) {
        if (!spec.getBasic().isPreprocessing()) {
            return null;
        }
        X13SpecDecoder helper = new X13SpecDecoder(spec, context);
        return helper.buildProcessor();
    }

    private RegArimaKernel(Builder builder) {
        this.modelBuilder = builder.modelBuilder;
        this.transformation = builder.transformation;
        this.calendarTest = builder.calendarTest;
        this.easterTest = builder.easterTest;
        this.outliers = builder.outliers;
        this.options = builder.options;
        this.autoModel = builder.autoModel;
        this.regressionTest0 = builder.regressionTest0;
        this.regressionTest1 = builder.regressionTest1;
        this.finalEstimator = FinalEstimator.builder().ami(this.autoModel != null).precision(this.options.precision).build();
    }

    private void clear() {
        this.round = 0;
        this.loop = 0;
        this.rtval0 = 0.0;
        this.rvr0 = 0.0;
        this.plbox0 = 0.0;
        this.reference = null;
        this.curva = 0.0;
        this.pcr = this.options.ljungBoxLimit;
        this.needAutoModelling = this.autoModel != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegSarimaModel process(TsData originalTs, ProcessingLog log) {
        if (log == null) {
            log = ProcessingLog.dummy();
        }
        this.clear();
        log.push(REGARIMA);
        try {
            RegSarimaModel rslt;
            ModelDescription desc = this.modelBuilder.build(originalTs, log);
            if (desc == null) {
                log.error("initialization failed");
                RegSarimaModel regSarimaModel = null;
                return regSarimaModel;
            }
            RegSarimaModelling context = RegSarimaModelling.of((ModelDescription)desc, (ProcessingLog)log);
            if (this.outliers != null) {
                this.va0 = this.options.getVa();
                if (this.va0 == 0.0) {
                    this.va0 = X13Utility.calcCv(desc.getSeries().getDomain().getLength());
                }
                this.curva = this.va0;
                this.needOutliers = true;
            }
            RegSarimaModel regSarimaModel = rslt = this.calc(context);
            return regSarimaModel;
        }
        finally {
            log.pop();
        }
    }

    private boolean isFullySpecified() {
        return this.transformation == null && this.outliers == null && this.autoModel == null && !this.options.checkMu && this.calendarTest == null && this.easterTest == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegSarimaModel calc(RegSarimaModelling context) {
        ProcessingLog log = context.getLog();
        if (context.getDescription().isLogTransformation() && context.getDescription().getSeries().getValues().anyMatch(x -> x <= 0.0)) {
            log.error(LOGNEG);
            return null;
        }
        try {
            Object controller;
            block33: {
                if (this.isFullySpecified()) {
                    this.finalEstimator.estimate(context);
                    RegSarimaModel regSarimaModel = context.build();
                    return regSarimaModel;
                }
                log.push(AMI);
                try {
                    log.step("round 0");
                    if (this.transformation != null) {
                        this.transformation.process(context);
                    }
                    this.regAIC(context);
                    this.checkMu(context, 1.96);
                    if (this.needOutliers && ProcessingResult.Changed == this.outliers.process(context, this.curva)) {
                        if (context.needEstimation()) {
                            context.estimate(this.options.precision);
                        }
                        this.regressionTest0.process(context);
                    }
                    if (this.isAutoModelling()) {
                        if (context.needEstimation()) {
                            context.estimate(this.options.precision);
                        }
                        this.reference = RegSarimaModelling.copyOf((RegSarimaModelling)context);
                        controller = new ModelController(0.95);
                        boolean ok = ((ModelController)controller).accept(context);
                        this.plbox0 = 1.0 - ((ModelController)controller).getLjungBoxTest().getPvalue();
                        this.rvr0 = ((ModelController)controller).getRvr();
                        this.rtval0 = ((ModelController)controller).getRTval();
                        if (this.options.acceptAirline && ok) break block33;
                        this.round = 1;
                        this.loop = 1;
                        do {
                            boolean checked;
                            ProcessingResult changed;
                            log.step(ROUND + this.round);
                            boolean defModel = false;
                            if (this.needAutoModelling) {
                                ProcessingResult amrslt = this.autoModel.process(context);
                                boolean bl = defModel = amrslt == ProcessingResult.Unchanged;
                                if (!defModel && context.getDescription().removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true))) {
                                    context.clearEstimation();
                                    boolean bl2 = this.needOutliers = this.outliers != null;
                                }
                                if (context.needEstimation()) {
                                    context.estimate(this.options.precision);
                                }
                                if (!defModel || this.loop > 1) {
                                    this.regAIC(context);
                                }
                            }
                            if (this.needOutliers) {
                                this.outliers.process(context, this.curva);
                                if (context.needEstimation()) {
                                    context.estimate(this.options.precision);
                                }
                            }
                            if (this.outliers != null && this.loop <= 2) {
                                if (!this.pass2(defModel, context)) {
                                    continue;
                                }
                            } else {
                                ((ModelController)controller).accept(context);
                                this.rtval0 = ((ModelController)controller).getRTval();
                                this.rvr0 = ((ModelController)controller).getRvr();
                                this.plbox0 = 1.0 - ((ModelController)controller).getLjungBoxTest().getPvalue();
                            }
                            if (this.regressionTest1 != null && (changed = this.regressionTest1.process(context)) == ProcessingResult.Changed) {
                                if (this.loop < 3) {
                                    this.loop = 3;
                                }
                                if (context.needEstimation()) {
                                    context.estimate(this.options.precision);
                                }
                                ((ModelController)controller).accept(context);
                                this.rtval0 = ((ModelController)controller).getRTval();
                                this.rvr0 = ((ModelController)controller).getRvr();
                                this.plbox0 = 1.0 - ((ModelController)controller).getLjungBoxTest().getPvalue();
                            }
                            do {
                                checked = true;
                                if (!this.checkUnitRoots(context)) {
                                    checked = false;
                                }
                                if (this.checkMA(context)) continue;
                                checked = false;
                            } while (!checked);
                            if (this.isAutoModelling() && !context.getDescription().isMean() && this.options.checkMu && this.rtval0 > 2.5) {
                                context.getDescription().setMean(true);
                                context.clearEstimation();
                            }
                            if (this.finalEstimator.estimate(context)) {
                                break block33;
                            }
                            if (this.loop > 2 || this.outliers == null) continue;
                            this.curva = Math.max(2.8, this.curva * (1.0 - this.options.reduceVa));
                            this.needOutliers = true;
                            this.needAutoModelling = true;
                        } while (this.round++ < 5);
                        break block33;
                    }
                    this.finalEstimator.estimate(context);
                }
                finally {
                    log.pop();
                }
            }
            controller = context.build();
            return controller;
        }
        catch (Exception err) {
            RegSarimaModel regSarimaModel = null;
            return regSarimaModel;
        }
        finally {
            this.clear();
        }
    }

    private boolean isAutoModelling() {
        return this.autoModel != null;
    }

    private ProcessingResult checkMu(RegSarimaModelling context, double cv) {
        if (!this.options.checkMu) {
            return ProcessingResult.Unchanged;
        }
        MeanController meanTest = new MeanController(cv);
        return meanTest.test(context);
    }

    private boolean pass2(boolean defModel, RegSarimaModelling context) {
        int ichk = 0;
        ModelDescription desc = context.getDescription();
        int naut = (int)desc.variables().filter(v -> ModellingUtility.isOutlier((Variable)v, (boolean)true)).count();
        ModelDescription desc0 = this.reference.getDescription();
        RegArimaEstimation estimation0 = this.reference.getEstimation();
        int naut0 = (int)desc0.variables().filter(v -> ModellingUtility.isOutlier((Variable)v, (boolean)true)).count();
        SarimaOrders spec0 = desc0.specification();
        SarimaOrders spec = desc.specification();
        SarimaModel arima = desc.arima();
        boolean mu0 = desc0.isMean();
        boolean mu = desc.isMean();
        ModelController controller = new ModelController(0.95);
        controller.accept(context);
        double rtval = controller.getRTval();
        double rvr = controller.getRvr();
        double plbox = 1.0 - controller.getLjungBoxTest().getPvalue();
        if (!(naut0 > naut || spec0.equals((Object)spec) && mu0 == mu)) {
            if (plbox < 0.95 && plbox < 0.75 && this.rvr0 < rvr) {
                ichk = 1;
            } else if (this.loop == 1 && plbox >= 0.95 && this.plbox0 < 0.95) {
                ichk = 2;
            } else if (plbox < 0.95 && this.plbox0 < 0.75 && this.plbox0 < plbox && this.rvr0 < 1.0126582278481011 * rvr) {
                ichk = 3;
            } else if (plbox >= 0.95 && this.plbox0 < 0.95 && this.rvr0 < 1.0 * rvr) {
                ichk = 4;
            } else if (spec.getD() == 0 && spec.getBd() == 1 && spec.getP() == 1 && spec.getBp() == 0 && spec.getQ() == 1 && spec.getBq() == 1 && arima.phi(1) < -0.82) {
                ichk = 5;
            } else if (spec.getD() == 1 && spec.getBd() == 0 && spec.getP() == 0 && spec.getBp() == 1 && spec.getQ() == 1 && spec.getBq() == 1 && arima.bphi(1) < -0.65) {
                ichk = 6;
            }
        }
        if (ichk > 0) {
            context.set(desc0, estimation0);
            plbox = this.plbox0;
            defModel = true;
        } else {
            this.rtval0 = rtval;
            this.rvr0 = rvr;
            this.plbox0 = plbox;
            this.reference = RegSarimaModelling.copyOf((RegSarimaModelling)context);
        }
        this.pcr = this.loop == 1 ? (this.pcr += 0.025) : (this.pcr += 0.015);
        ++this.loop;
        if (plbox <= this.pcr) {
            return true;
        }
        boolean ncv = false;
        if (this.loop == 2 && this.outliers != null) {
            if (this.curva > 2.8) {
                this.curva = Math.max(2.8, this.curva * (1.0 - this.options.reduceVa));
                ncv = true;
                context.getLog().warning(OUTLIERS_VA_REDUCED);
            }
            this.needOutliers = true;
        }
        boolean bl = this.needAutoModelling = !defModel;
        if (this.loop > 2 || !ncv) {
            context.getLog().warning(LAST_CHANCE);
            this.lastSolution(context);
            if (this.loop == 2) {
                this.loop = 3;
            }
        }
        return false;
    }

    private void lastSolution(RegSarimaModelling context) {
        ModelDescription description = context.getDescription();
        SarimaOrders nspec = description.specification();
        switch (nspec.getPeriod()) {
            case 2: {
                nspec.setP(1);
                break;
            }
            case 3: {
                nspec.setP(2);
                break;
            }
            default: {
                nspec.setP(3);
            }
        }
        if (nspec.getBd() > 0 || nspec.getPeriod() == 1) {
            nspec.setBp(0);
        }
        if (this.options.mixedModel) {
            nspec.setQ(1);
        } else {
            nspec.setQ(0);
        }
        if (nspec.getPeriod() > 1) {
            nspec.setBq(1);
        }
        context.setSpecification(nspec);
        context.estimate(this.options.precision);
        if (this.outliers != null) {
            this.curva = this.va0;
            this.needOutliers = true;
        }
        this.needAutoModelling = false;
    }

    private ProcessingResult regAIC(RegSarimaModelling context) {
        ProcessingResult rslt = ProcessingResult.Unchanged;
        if (this.calendarTest != null && this.calendarTest.test(context) == ProcessingResult.Changed) {
            rslt = ProcessingResult.Changed;
        }
        if (this.easterTest != null && this.easterTest.test(context) == ProcessingResult.Changed) {
            rslt = ProcessingResult.Changed;
        }
        return rslt;
    }

    private boolean checkUnitRoots(RegSarimaModelling context) {
        ModelDescription desc = context.getDescription();
        SarimaModel m = desc.arima();
        SarimaOrders nspec = m.orders();
        boolean ok = true;
        if (nspec.getP() > 0 && nspec.getD() < 2 && 0 != this.searchur(m.getRegularAR().mirror().roots())) {
            nspec.setP(nspec.getP() - 1);
            nspec.setD(nspec.getD() + 1);
            ok = false;
        }
        if (nspec.getBp() > 0 && nspec.getBd() < 1 && 0 != this.searchur(m.getSeasonalAR().mirror().roots())) {
            nspec.setBp(nspec.getBp() - 1);
            nspec.setBd(nspec.getBd() + 1);
            ok = false;
        }
        if (!ok) {
            desc.setSpecification(nspec);
            this.redoEstimation(context);
        }
        return ok;
    }

    private void redoEstimation(RegSarimaModelling context) {
        context.estimate(this.options.precision);
        ModelDescription desc = context.getDescription();
        if (desc.isMean()) {
            this.checkMu(context, 1.6);
        }
        if (desc.variables().filter(v -> ModellingUtility.isOutlier((Variable)v, (boolean)true)).findAny().isPresent()) {
            desc.removeVariable(v -> ModellingUtility.isOutlier((Variable)v, (boolean)true));
            context.clearEstimation();
        }
        if (context.needEstimation()) {
            context.estimate(this.options.precision);
        }
        if (this.outliers != null) {
            this.outliers.process(context, this.curva);
        }
        if (context.needEstimation()) {
            context.estimate(this.options.precision);
        }
        ModelController controller = new ModelController(0.95);
        controller.accept(context);
        this.rtval0 = controller.getRTval();
        this.rvr0 = controller.getRvr();
        this.plbox0 = 1.0 - controller.getLjungBoxTest().getPvalue();
        this.reference = RegSarimaModelling.copyOf((RegSarimaModelling)context);
    }

    private int searchur(Complex[] r) {
        if (r == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < r.length; ++i) {
            double cdim = Math.abs(r[i].getIm());
            double vcur = r[i].abs();
            if (!(vcur > this.options.urLimit) || !(cdim <= 0.05) || !(r[i].getRe() > 0.0)) continue;
            ++n;
        }
        return n;
    }

    private boolean checkMA(RegSarimaModelling context) {
        ModelDescription description = context.getDescription();
        SarimaModel m = description.arima();
        SarimaOrders nspec = m.orders();
        if (nspec.getQ() == 0 || nspec.getD() == 0) {
            return true;
        }
        double ma = m.getRegularMA().evaluateAt(1.0);
        if (Math.abs(ma) < 0.001) {
            nspec.setQ(nspec.getQ() - 1);
            nspec.setD(nspec.getD() - 1);
            description.setSpecification(nspec);
            description.setMean(true);
            this.redoEstimation(context);
            return false;
        }
        return true;
    }

    public static class Builder {
        private IModelBuilder modelBuilder = new DefaultModelBuilder();
        private ILogLevelModule transformation;
        private IRegressionModule calendarTest;
        private IRegressionModule easterTest;
        private IAutoModellingModule autoModel;
        private IOutliersDetectionModule outliers;
        private RegressionVariablesTest regressionTest0;
        private RegressionVariablesTest regressionTest1;
        private AmiOptions options = AmiOptions.builder().build();

        public Builder modelBuilder(@NonNull IModelBuilder builder) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            this.modelBuilder = builder;
            return this;
        }

        public Builder options(AmiOptions options) {
            this.options = options;
            return this;
        }

        public Builder logLevel(ILogLevelModule ll) {
            this.transformation = ll;
            return this;
        }

        public Builder autoModelling(IAutoModellingModule ami) {
            this.autoModel = ami;
            return this;
        }

        public Builder calendarTest(IRegressionModule calendarTest) {
            this.calendarTest = calendarTest;
            return this;
        }

        public Builder easterTest(IRegressionModule easterTest) {
            this.easterTest = easterTest;
            return this;
        }

        public Builder outliers(IOutliersDetectionModule outliers) {
            this.outliers = outliers;
            return this;
        }

        public Builder initialRegressionTest(RegressionVariablesTest test0) {
            this.regressionTest0 = test0;
            return this;
        }

        public Builder finalRegressionTest(RegressionVariablesTest test1) {
            this.regressionTest1 = test1;
            return this;
        }

        public RegArimaKernel build() {
            RegArimaKernel processor = new RegArimaKernel(this);
            return processor;
        }
    }

    public static final class AmiOptions {
        public static final double DEF_EPS = 1.0E-7;
        public static final double DEF_IEPS = 1.0E-7;
        private final boolean checkMu;
        private final double precision;
        private final double intermediatePrecision;
        private final double va;
        private final double reduceVa;
        private final double ljungBoxLimit;
        private final double urLimit;
        private final boolean acceptAirline;
        private final boolean mixedModel;

        public static AmiBuilder builder() {
            AmiBuilder builder = new AmiBuilder();
            builder.checkMu = true;
            builder.precision = 1.0E-7;
            builder.intermediatePrecision = 1.0E-7;
            builder.va = 0.0;
            builder.reduceVa = 0.14286;
            builder.ljungBoxLimit = 0.95;
            builder.urLimit = 0.95;
            builder.acceptAirline = false;
            builder.mixedModel = true;
            return builder;
        }

        @Generated
        AmiOptions(boolean checkMu, double precision, double intermediatePrecision, double va, double reduceVa, double ljungBoxLimit, double urLimit, boolean acceptAirline, boolean mixedModel) {
            this.checkMu = checkMu;
            this.precision = precision;
            this.intermediatePrecision = intermediatePrecision;
            this.va = va;
            this.reduceVa = reduceVa;
            this.ljungBoxLimit = ljungBoxLimit;
            this.urLimit = urLimit;
            this.acceptAirline = acceptAirline;
            this.mixedModel = mixedModel;
        }

        @Generated
        public boolean isCheckMu() {
            return this.checkMu;
        }

        @Generated
        public double getPrecision() {
            return this.precision;
        }

        @Generated
        public double getIntermediatePrecision() {
            return this.intermediatePrecision;
        }

        @Generated
        public double getVa() {
            return this.va;
        }

        @Generated
        public double getReduceVa() {
            return this.reduceVa;
        }

        @Generated
        public double getLjungBoxLimit() {
            return this.ljungBoxLimit;
        }

        @Generated
        public double getUrLimit() {
            return this.urLimit;
        }

        @Generated
        public boolean isAcceptAirline() {
            return this.acceptAirline;
        }

        @Generated
        public boolean isMixedModel() {
            return this.mixedModel;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmiOptions)) {
                return false;
            }
            AmiOptions other = (AmiOptions)o;
            if (this.isCheckMu() != other.isCheckMu()) {
                return false;
            }
            if (Double.compare(this.getPrecision(), other.getPrecision()) != 0) {
                return false;
            }
            if (Double.compare(this.getIntermediatePrecision(), other.getIntermediatePrecision()) != 0) {
                return false;
            }
            if (Double.compare(this.getVa(), other.getVa()) != 0) {
                return false;
            }
            if (Double.compare(this.getReduceVa(), other.getReduceVa()) != 0) {
                return false;
            }
            if (Double.compare(this.getLjungBoxLimit(), other.getLjungBoxLimit()) != 0) {
                return false;
            }
            if (Double.compare(this.getUrLimit(), other.getUrLimit()) != 0) {
                return false;
            }
            if (this.isAcceptAirline() != other.isAcceptAirline()) {
                return false;
            }
            return this.isMixedModel() == other.isMixedModel();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCheckMu() ? 79 : 97);
            long $precision = Double.doubleToLongBits(this.getPrecision());
            result = result * 59 + (int)($precision >>> 32 ^ $precision);
            long $intermediatePrecision = Double.doubleToLongBits(this.getIntermediatePrecision());
            result = result * 59 + (int)($intermediatePrecision >>> 32 ^ $intermediatePrecision);
            long $va = Double.doubleToLongBits(this.getVa());
            result = result * 59 + (int)($va >>> 32 ^ $va);
            long $reduceVa = Double.doubleToLongBits(this.getReduceVa());
            result = result * 59 + (int)($reduceVa >>> 32 ^ $reduceVa);
            long $ljungBoxLimit = Double.doubleToLongBits(this.getLjungBoxLimit());
            result = result * 59 + (int)($ljungBoxLimit >>> 32 ^ $ljungBoxLimit);
            long $urLimit = Double.doubleToLongBits(this.getUrLimit());
            result = result * 59 + (int)($urLimit >>> 32 ^ $urLimit);
            result = result * 59 + (this.isAcceptAirline() ? 79 : 97);
            result = result * 59 + (this.isMixedModel() ? 79 : 97);
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "RegArimaKernel.AmiOptions(checkMu=" + this.isCheckMu() + ", precision=" + this.getPrecision() + ", intermediatePrecision=" + this.getIntermediatePrecision() + ", va=" + this.getVa() + ", reduceVa=" + this.getReduceVa() + ", ljungBoxLimit=" + this.getLjungBoxLimit() + ", urLimit=" + this.getUrLimit() + ", acceptAirline=" + this.isAcceptAirline() + ", mixedModel=" + this.isMixedModel() + ")";
        }

        @Generated
        public static class AmiBuilder {
            @Generated
            private boolean checkMu;
            @Generated
            private double precision;
            @Generated
            private double intermediatePrecision;
            @Generated
            private double va;
            @Generated
            private double reduceVa;
            @Generated
            private double ljungBoxLimit;
            @Generated
            private double urLimit;
            @Generated
            private boolean acceptAirline;
            @Generated
            private boolean mixedModel;

            @Generated
            AmiBuilder() {
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiBuilder checkMu(boolean checkMu) {
                this.checkMu = checkMu;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiBuilder precision(double precision) {
                this.precision = precision;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiBuilder intermediatePrecision(double intermediatePrecision) {
                this.intermediatePrecision = intermediatePrecision;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiBuilder va(double va) {
                this.va = va;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiBuilder reduceVa(double reduceVa) {
                this.reduceVa = reduceVa;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiBuilder ljungBoxLimit(double ljungBoxLimit) {
                this.ljungBoxLimit = ljungBoxLimit;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiBuilder urLimit(double urLimit) {
                this.urLimit = urLimit;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiBuilder acceptAirline(boolean acceptAirline) {
                this.acceptAirline = acceptAirline;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiBuilder mixedModel(boolean mixedModel) {
                this.mixedModel = mixedModel;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull AmiOptions build() {
                return new AmiOptions(this.checkMu, this.precision, this.intermediatePrecision, this.va, this.reduceVa, this.ljungBoxLimit, this.urLimit, this.acceptAirline, this.mixedModel);
            }

            @Generated
            public @org.jspecify.annotations.NonNull String toString() {
                return "RegArimaKernel.AmiOptions.AmiBuilder(checkMu=" + this.checkMu + ", precision=" + this.precision + ", intermediatePrecision=" + this.intermediatePrecision + ", va=" + this.va + ", reduceVa=" + this.reduceVa + ", ljungBoxLimit=" + this.ljungBoxLimit + ", urLimit=" + this.urLimit + ", acceptAirline=" + this.acceptAirline + ", mixedModel=" + this.mixedModel + ")";
            }
        }
    }
}

