/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.integer;

import choco.kernel.model.IConstraintList;
import choco.kernel.model.variables.ComponentVariable;
import choco.kernel.model.variables.IntBoundedVariable;
import choco.kernel.model.variables.Operator;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;

public class IntegerExpressionVariable
extends ComponentVariable
implements IntBoundedVariable {
    protected int lowB = Integer.MAX_VALUE;
    protected int uppB = Integer.MIN_VALUE;

    protected IntegerExpressionVariable(VariableType variableType, Object parameters, boolean enableOption, IConstraintList constraints) {
        super(variableType, enableOption, parameters, constraints);
    }

    public IntegerExpressionVariable(Object parameters, Operator operator, IntegerExpressionVariable ... variables) {
        super(VariableType.INTEGER_EXPRESSION, operator, parameters, (ComponentVariable[])variables);
    }

    public IntegerExpressionVariable(Object parameters, String operator, IntegerExpressionVariable ... variables) {
        super(VariableType.INTEGER_EXPRESSION, operator, parameters, (ComponentVariable[])variables);
    }

    public IntegerExpressionVariable(Object parameters, Class operator, IntegerExpressionVariable ... variables) {
        this(parameters, operator.getName(), variables);
    }

    private void initializeBounds() {
        if (this.operator != null && !this.operator.equals((Object)Operator.NONE)) {
            this.computeBounds();
        }
    }

    public final IntegerExpressionVariable getExpressionVariable(int i) {
        return (IntegerExpressionVariable)this.getVariable(i);
    }

    @Override
    public final int getLowB() {
        if (this.lowB == Integer.MAX_VALUE) {
            this.initializeBounds();
        }
        return this.lowB;
    }

    @Override
    public void setLowB(int lowB) {
        this.lowB = lowB;
    }

    @Override
    public final int getUppB() {
        if (this.uppB == Integer.MIN_VALUE) {
            this.initializeBounds();
        }
        return this.uppB;
    }

    @Override
    public void setUppB(int uppB) {
        this.uppB = uppB;
    }

    private void computeBounds() {
        this.lowB = Integer.MAX_VALUE;
        this.uppB = Integer.MIN_VALUE;
        switch (this.operator.parameters) {
            case 0: {
                int[] val = this.computeByNOperator();
                this.lowB = val[0] < this.lowB ? val[0] : this.lowB;
                this.uppB = val[1] > this.uppB ? val[1] : this.uppB;
                break;
            }
            case 1: {
                int[] val = this.computeByOperator(0);
                this.lowB = val[0] < this.lowB ? val[0] : this.lowB;
                this.uppB = val[1] > this.uppB ? val[1] : this.uppB;
                break;
            }
            case 2: {
                int[] val = this.computeByOperator(0, 1);
                this.lowB = val[0] < this.lowB ? val[0] : this.lowB;
                this.uppB = val[1] > this.uppB ? val[1] : this.uppB;
                break;
            }
        }
    }

    private int[] computeByOperator(int i) {
        IntegerExpressionVariable v = this.getExpressionVariable(i);
        int i1 = v.getLowB();
        int s1 = v.getUppB();
        int[] vals = new int[2];
        switch (this.operator) {
            case ABS: {
                vals[0] = Math.min(Math.abs(i1), Math.abs(s1));
                if (i1 < 0 && s1 > 0) {
                    vals[0] = 0;
                }
                vals[1] = Math.max(Math.abs(i1), Math.abs(s1));
                break;
            }
            case NEG: {
                vals[0] = -s1;
                vals[1] = -i1;
                break;
            }
            case NONE: {
                break;
            }
            default: {
                vals[0] = Integer.MIN_VALUE;
                vals[1] = Integer.MAX_VALUE;
            }
        }
        return vals;
    }

    private int[] computeByOperator(int i, int j) {
        IntegerExpressionVariable v1 = this.getExpressionVariable(i);
        int i1 = v1.getLowB();
        int s1 = v1.getUppB();
        IntegerExpressionVariable v2 = (IntegerExpressionVariable)this.getVariable(j);
        int i2 = v2.getLowB();
        int s2 = v2.getUppB();
        int[] vals = new int[4];
        switch (this.operator) {
            case MINUS: {
                vals[0] = i1 - i2;
                vals[1] = i1 - s2;
                vals[2] = s1 - i2;
                vals[3] = s1 - s2;
                break;
            }
            case MOD: {
                if (i2 == 0 && s2 == 0) {
                    vals[0] = Integer.MIN_VALUE;
                    vals[1] = Integer.MIN_VALUE;
                    vals[2] = Integer.MAX_VALUE;
                    vals[3] = Integer.MAX_VALUE;
                    break;
                }
                if (s2 == 0) {
                    s2 = 1;
                }
                if (i2 == 0) {
                    i2 = 1;
                }
                vals[0] = i1 % i2;
                vals[1] = i1 % s2;
                vals[2] = s1 % i2;
                vals[3] = s1 % s2;
                break;
            }
            case MULT: {
                vals[0] = i1 * i2;
                vals[1] = i1 * s2;
                vals[2] = s1 * i2;
                vals[3] = s1 * s2;
                break;
            }
            case NONE: {
                break;
            }
            case PLUS: {
                vals[0] = i1 + i2;
                vals[1] = i1 + s2;
                vals[2] = s1 + i2;
                vals[3] = s1 + s2;
                break;
            }
            case POWER: {
                vals[0] = (int)Math.pow(i1, i2);
                vals[1] = (int)Math.pow(i1, s2);
                vals[2] = (int)Math.pow(s1, i2);
                vals[3] = (int)Math.pow(s1, s2);
                break;
            }
            default: {
                vals[0] = Integer.MIN_VALUE;
                vals[1] = Integer.MIN_VALUE;
                vals[2] = Integer.MAX_VALUE;
                vals[3] = Integer.MAX_VALUE;
            }
        }
        int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (int val : vals) {
            bounds[0] = Math.min(bounds[0], val);
            bounds[1] = Math.max(bounds[1], val);
        }
        return bounds;
    }

    private int[] computeByNOperator() {
        int n = this.getNbVars();
        int i1 = 0;
        int s1 = 0;
        int i = 0;
        int[] vals = new int[4];
        switch (this.operator) {
            case SCALAR: {
                int cste = n / 2;
                do {
                    int val2 = ((IntegerConstantVariable)this.getVariable(i)).getValue();
                    IntegerExpressionVariable v = (IntegerExpressionVariable)this.getVariable(i + cste);
                    int i2 = v.getLowB() * val2;
                    int s2 = v.getUppB() * val2;
                    vals[0] = i1 + i2;
                    vals[1] = i1 + s2;
                    vals[2] = s1 + i2;
                    vals[3] = s1 + s2;
                    i1 = Integer.MAX_VALUE;
                    s1 = Integer.MIN_VALUE;
                    for (int val : vals) {
                        i1 = Math.min(i1, val);
                        s1 = Math.max(s1, val);
                    }
                } while (++i < cste);
                break;
            }
            case SUM: {
                do {
                    IntegerExpressionVariable v = this.getExpressionVariable(i);
                    int i2 = v.getLowB();
                    int s2 = v.getUppB();
                    vals[0] = i1 + i2;
                    vals[1] = i1 + s2;
                    vals[2] = s1 + i2;
                    vals[3] = s1 + s2;
                    i1 = Integer.MAX_VALUE;
                    s1 = Integer.MIN_VALUE;
                    for (int val : vals) {
                        i1 = Math.min(i1, val);
                        s1 = Math.max(s1, val);
                    }
                } while (++i < n);
                break;
            }
            case MAX: {
                i1 = Integer.MIN_VALUE;
                s1 = Integer.MIN_VALUE;
                for (int k = 0; k < n; ++k) {
                    IntegerExpressionVariable v = this.getExpressionVariable(k);
                    int i2 = v.getLowB();
                    int s2 = v.getUppB();
                    i1 = Math.max(i1, i2);
                    s1 = Math.max(s1, s2);
                }
                break;
            }
            case MIN: {
                i1 = Integer.MAX_VALUE;
                s1 = Integer.MAX_VALUE;
                for (int k = 0; k < n; ++k) {
                    IntegerExpressionVariable v = this.getExpressionVariable(k);
                    int i2 = v.getLowB();
                    int s2 = v.getUppB();
                    i1 = Math.min(i1, i2);
                    s1 = Math.min(s1, s2);
                }
                break;
            }
            default: {
                i1 = Integer.MIN_VALUE;
                s1 = Integer.MAX_VALUE;
            }
        }
        return new int[]{i1, s1};
    }
}

