/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.linearmodel;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class BreuschGodfrey {
    private int lag = 1;
    private final LeastSquaresResults lsr;
    private LeastSquaresResults lsr2;

    public BreuschGodfrey(LinearModel lm) {
        this(Ols.compute(lm));
    }

    public BreuschGodfrey(LeastSquaresResults lsr) {
        this.lsr = lsr;
    }

    public BreuschGodfrey lag(int lag) {
        this.lag = lag;
        return this;
    }

    public StatisticalTest build() {
        if (!this.lsr.isMean()) {
            throw new IllegalArgumentException("lm should contain a mean correction");
        }
        Matrix X = this.lsr.X();
        DoubleSeq u = this.lsr.residuals();
        int n = X.getRowsCount();
        int m = X.getColumnsCount();
        LinearModel.Builder builder = LinearModel.builder().y(u.drop(this.lag, 0)).addX(X.extract(this.lag, n - this.lag, 1, m - 1)).meanCorrection(true);
        for (int i = 1; i <= this.lag; ++i) {
            builder.addX(u.drop(this.lag - i, i));
        }
        this.lsr2 = Ols.compute(builder.build());
        double val = this.lsr2.getR2() * (double)(n - this.lag);
        Chi2 chi = new Chi2(this.lag);
        return TestsUtility.testOf(val, chi, TestType.Upper);
    }

    public LeastSquaresResults getLeastSquaresResults() {
        return this.lsr2;
    }
}

