/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree;

import choco.cp.solver.constraints.global.tree.deduction.DeductionsAdvisor;
import choco.cp.solver.constraints.global.tree.filtering.FilteringAdvisor;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.StructuresAdvisor;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class TreeSConstraint
extends AbstractLargeIntSConstraint {
    protected static final boolean AFFICHE = false;
    protected Solver solver;
    protected TreeParameters tree;
    protected int nbNodes;
    protected StructuresAdvisor structure;
    protected DeductionsAdvisor deduction;
    protected FilteringAdvisor filtering;

    public TreeSConstraint(IntDomainVar[] allVars, TreeParameters tree) {
        super(ConstraintEvent.VERY_SLOW, allVars);
        this.tree = tree;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        LOGGER.severe("TreeSConstraint#isSatisfied(int[] tuple) is not implemented and always returns true!");
        return true;
    }

    @Override
    public boolean isSatisfied() {
        LOGGER.severe("TreeSConstraint#isSatisfied() is not implemented and always returns true!");
        return true;
    }

    @Override
    public void awake() throws ContradictionException {
        this.solver = this.tree.getSolver();
        this.nbNodes = this.tree.getNbNodes();
        this.structure = new StructuresAdvisor(this.solver, this.tree);
        this.deduction = new DeductionsAdvisor(this.solver, this.tree, this.structure, false);
        this.filtering = new FilteringAdvisor(this.solver, this, this.tree, this.structure, false);
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        boolean update;
        do {
            this.structure.applyStructure();
            update = this.deduction.applyDeduction();
            if (!this.deduction.isCompatible()) {
                update = false;
                this.fail();
                continue;
            }
            boolean bl = update = this.filtering.applyFiltering() || update;
        } while (update);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            this.structure.getInputGraph().updateOnInst(idx - 3);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            this.structure.getInputGraph().updateOnInf(idx - 3);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            this.structure.getInputGraph().updateOnSup(idx - 3);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            this.structure.getInputGraph().updateOnBounds(idx - 3);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnRem(int idx, int i) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            this.structure.getInputGraph().updateOnRem(idx - 3, i);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            this.structure.getInputGraph().updateOnRemovals(idx - 3, deltaDomain);
        }
        this.constAwake(false);
    }
}

