## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 5
)

## ----dwd-et0, eval=FALSE------------------------------------------------------
# ET0 <- WaterBalanceR::DownloadET0fromDWD(
#   target_path   = "path/to/output",
#   test_site_shp = "path/to/shapefile/AOI.shp",
#   target_year   = 2023,
#   timeout       = 10000
# )

## ----arable-et0, eval=FALSE---------------------------------------------------
# ET0_arable <- WaterBalanceR::DownloadET0fromArable(
#   arable_user = "username",
#   arable_pass = "password",
#   target_year = 2023,
#   target_path = "path/to/output"
# )

## ----radolan, eval=FALSE------------------------------------------------------
# WaterBalanceR::DownloadRadolanfromDWD(
#   target_path   = "path/to/output",
#   target_year   = 2023,
#   test_site_shp = "path/to/AOI.shp",
#   timeout       = 10000
# )

## ----raindancer, eval=FALSE---------------------------------------------------
# WaterBalanceR::DownloadRaindancer(
#   user         = "raindancer_user",
#   password     = "raindancer_pass",
#   target_path  = "path/to/output",
#   target_year  = 2023
# )

## ----combine-raindancer, eval=FALSE-------------------------------------------
# WaterBalanceR::DownloadRaindancerCombineCharts(
#   input_folder = "path/to/Raindancer/charts/",
#   output_file  = "path/to/output/combined_irrigation.csv"
# )

## ----sentinel2, eval=FALSE----------------------------------------------------
# WaterBalanceR::DownloadSentinel2(
#   target_path   = "path/to/output",
#   shape_site = "path/to/AOI.shp",
#   start_date = "2025-06-01"
#   end_date = "2025-08-01"
#   max_cld     = 10
# )

## ----example-integration, eval=FALSE------------------------------------------
# WaterBalanceR::calcWB(
#   mypath          = "project_root",
#   ET_ref          = read.csv("project_root/DWD_ET0_2023.csv"),
#   path_WR_precip  = "project_root/Radolan_2023_processed_daily",
#   irrig_sf        = "project_root/Shapefile/Buffer_36m_all_interp.shp",
#   precip_source   = "radolan"
# )

## ----reproducibility, eval=FALSE----------------------------------------------
# system.file("sample_data", package = "WaterBalanceR")

## ----session-info-------------------------------------------------------------
sessionInfo()

