/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.advanced.arima;

import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.advanced.arima.ArimaLoader;
import jdplus.toolkit.base.api.advanced.arima.ArimaModel;
import jdplus.toolkit.base.api.advanced.arima.UcarimaModel;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import lombok.Generated;

public final class Arima {
    private static final ArimaLoader.Processor PROCESSOR = new ArimaLoader.Processor();

    public static void setProcessor(Processor processor) {
        PROCESSOR.set(processor);
    }

    public static Processor getProcessor() {
        return PROCESSOR.get();
    }

    public static IntToDoubleFunction autoCovarianceFunction(ArimaModel process) {
        return PROCESSOR.get().autoCovarianceFunction(process);
    }

    public static DoubleUnaryOperator pseudoSpectrum(ArimaModel process) {
        return PROCESSOR.get().pseudoSpectrum(process);
    }

    public static IntToDoubleFunction piWeights(ArimaModel process) {
        return PROCESSOR.get().piWeights(process);
    }

    public static IntToDoubleFunction psiWeights(ArimaModel process) {
        return PROCESSOR.get().psiWeights(process);
    }

    public static ArimaModel plus(ArimaModel left, ArimaModel right) {
        return PROCESSOR.get().plus(left, right);
    }

    public static ArimaModel minus(ArimaModel left, ArimaModel right) {
        return PROCESSOR.get().minus(left, right);
    }

    public static ArimaModel plus(ArimaModel left, double noise) {
        return PROCESSOR.get().plus(left, noise);
    }

    public static ArimaModel minus(ArimaModel left, double noise) {
        return PROCESSOR.get().minus(left, noise);
    }

    public static UcarimaModel doCanonical(UcarimaModel ucarima) {
        return PROCESSOR.get().doCanonical(ucarima);
    }

    @Generated
    private Arima() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface Processor {
        public IntToDoubleFunction autoCovarianceFunction(ArimaModel var1);

        public DoubleUnaryOperator pseudoSpectrum(ArimaModel var1);

        public IntToDoubleFunction piWeights(ArimaModel var1);

        public IntToDoubleFunction psiWeights(ArimaModel var1);

        public ArimaModel plus(ArimaModel var1, ArimaModel var2);

        public ArimaModel minus(ArimaModel var1, ArimaModel var2);

        public ArimaModel plus(ArimaModel var1, double var2);

        public ArimaModel minus(ArimaModel var1, double var2);

        public UcarimaModel doCanonical(UcarimaModel var1);
    }
}

