% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-colorder-relocate.R
\name{relocate.dtplyr_step}
\alias{relocate.dtplyr_step}
\title{Relocate variables using their names}
\usage{
\method{relocate}{dtplyr_step}(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to move.}

\item{.before, .after}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Destination of
columns selected by \code{...}. Supplying neither will move columns to the
left-hand side; specifying both is an error.}
}
\description{
This is a method for the dplyr \code{\link[dplyr:relocate]{dplyr::relocate()}} generic. It is translated to
the \code{j} argument of \verb{[.data.table}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(data.frame(x = 1, y = 2, z = 3))

dt \%>\% relocate(z)
dt \%>\% relocate(y, .before = x)
dt \%>\% relocate(y, .after = y)
}
