// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Adjustment, Align, Buildable, CellArea, CellLayout, CellRenderer, Container,
    IconViewDropPosition, MovementStep, Orientation, ResizeMode, Scrollable, ScrollablePolicy,
    SelectionMode, Tooltip, TreeIter, TreeModel, TreePath, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute, ptr};

glib::wrapper! {
    #[doc(alias = "GtkIconView")]
    pub struct IconView(Object<ffi::GtkIconView, ffi::GtkIconViewClass>) @extends Container, Widget, @implements Buildable, CellLayout, Scrollable;

    match fn {
        type_ => || ffi::gtk_icon_view_get_type(),
    }
}

impl IconView {
    pub const NONE: Option<&'static IconView> = None;

    #[doc(alias = "gtk_icon_view_new")]
    pub fn new() -> IconView {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_icon_view_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_icon_view_new_with_area")]
    #[doc(alias = "new_with_area")]
    pub fn with_area(area: &impl IsA<CellArea>) -> IconView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_icon_view_new_with_area(
                area.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_icon_view_new_with_model")]
    #[doc(alias = "new_with_model")]
    pub fn with_model(model: &impl IsA<TreeModel>) -> IconView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_icon_view_new_with_model(
                model.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`IconView`] objects.
    ///
    /// This method returns an instance of [`IconViewBuilder`](crate::builders::IconViewBuilder) which can be used to create [`IconView`] objects.
    pub fn builder() -> IconViewBuilder {
        IconViewBuilder::new()
    }
}

impl Default for IconView {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`IconView`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct IconViewBuilder {
    builder: glib::object::ObjectBuilder<'static, IconView>,
}

impl IconViewBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn activate_on_single_click(self, activate_on_single_click: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("activate-on-single-click", activate_on_single_click),
        }
    }

    pub fn cell_area(self, cell_area: &impl IsA<CellArea>) -> Self {
        Self {
            builder: self
                .builder
                .property("cell-area", cell_area.clone().upcast()),
        }
    }

    pub fn column_spacing(self, column_spacing: i32) -> Self {
        Self {
            builder: self.builder.property("column-spacing", column_spacing),
        }
    }

    pub fn columns(self, columns: i32) -> Self {
        Self {
            builder: self.builder.property("columns", columns),
        }
    }

    pub fn item_orientation(self, item_orientation: Orientation) -> Self {
        Self {
            builder: self.builder.property("item-orientation", item_orientation),
        }
    }

    pub fn item_padding(self, item_padding: i32) -> Self {
        Self {
            builder: self.builder.property("item-padding", item_padding),
        }
    }

    pub fn item_width(self, item_width: i32) -> Self {
        Self {
            builder: self.builder.property("item-width", item_width),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn markup_column(self, markup_column: i32) -> Self {
        Self {
            builder: self.builder.property("markup-column", markup_column),
        }
    }

    pub fn model(self, model: &impl IsA<TreeModel>) -> Self {
        Self {
            builder: self.builder.property("model", model.clone().upcast()),
        }
    }

    pub fn pixbuf_column(self, pixbuf_column: i32) -> Self {
        Self {
            builder: self.builder.property("pixbuf-column", pixbuf_column),
        }
    }

    pub fn reorderable(self, reorderable: bool) -> Self {
        Self {
            builder: self.builder.property("reorderable", reorderable),
        }
    }

    pub fn row_spacing(self, row_spacing: i32) -> Self {
        Self {
            builder: self.builder.property("row-spacing", row_spacing),
        }
    }

    pub fn selection_mode(self, selection_mode: SelectionMode) -> Self {
        Self {
            builder: self.builder.property("selection-mode", selection_mode),
        }
    }

    pub fn spacing(self, spacing: i32) -> Self {
        Self {
            builder: self.builder.property("spacing", spacing),
        }
    }

    pub fn text_column(self, text_column: i32) -> Self {
        Self {
            builder: self.builder.property("text-column", text_column),
        }
    }

    pub fn tooltip_column(self, tooltip_column: i32) -> Self {
        Self {
            builder: self.builder.property("tooltip-column", tooltip_column),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn hadjustment(self, hadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("hadjustment", hadjustment.clone().upcast()),
        }
    }

    pub fn hscroll_policy(self, hscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("hscroll-policy", hscroll_policy),
        }
    }

    pub fn vadjustment(self, vadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("vadjustment", vadjustment.clone().upcast()),
        }
    }

    pub fn vscroll_policy(self, vscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("vscroll-policy", vscroll_policy),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`IconView`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> IconView {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::IconView>> Sealed for T {}
}

pub trait IconViewExt: IsA<IconView> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_icon_view_convert_widget_to_bin_window_coords")]
    fn convert_widget_to_bin_window_coords(&self, wx: i32, wy: i32) -> (i32, i32) {
        unsafe {
            let mut bx = mem::MaybeUninit::uninit();
            let mut by = mem::MaybeUninit::uninit();
            ffi::gtk_icon_view_convert_widget_to_bin_window_coords(
                self.as_ref().to_glib_none().0,
                wx,
                wy,
                bx.as_mut_ptr(),
                by.as_mut_ptr(),
            );
            (bx.assume_init(), by.assume_init())
        }
    }

    #[doc(alias = "gtk_icon_view_create_drag_icon")]
    fn create_drag_icon(&self, path: &TreePath) -> Option<cairo::Surface> {
        unsafe {
            from_glib_full(ffi::gtk_icon_view_create_drag_icon(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_activate_on_single_click")]
    #[doc(alias = "get_activate_on_single_click")]
    fn activates_on_single_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_icon_view_get_activate_on_single_click(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_cell_rect")]
    #[doc(alias = "get_cell_rect")]
    fn cell_rect(
        &self,
        path: &TreePath,
        cell: Option<&impl IsA<CellRenderer>>,
    ) -> Option<gdk::Rectangle> {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            let ret = from_glib(ffi::gtk_icon_view_get_cell_rect(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                cell.map(|p| p.as_ref()).to_glib_none().0,
                rect.to_glib_none_mut().0,
            ));
            if ret {
                Some(rect)
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_column_spacing")]
    #[doc(alias = "get_column_spacing")]
    fn column_spacing(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_column_spacing(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_columns")]
    #[doc(alias = "get_columns")]
    fn columns(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_columns(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_cursor")]
    #[doc(alias = "get_cursor")]
    fn cursor(&self) -> Option<(TreePath, CellRenderer)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut cell = ptr::null_mut();
            let ret = from_glib(ffi::gtk_icon_view_get_cursor(
                self.as_ref().to_glib_none().0,
                &mut path,
                &mut cell,
            ));
            if ret {
                Some((from_glib_full(path), from_glib_none(cell)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_dest_item_at_pos")]
    #[doc(alias = "get_dest_item_at_pos")]
    fn dest_item_at_pos(
        &self,
        drag_x: i32,
        drag_y: i32,
    ) -> Option<(TreePath, IconViewDropPosition)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_icon_view_get_dest_item_at_pos(
                self.as_ref().to_glib_none().0,
                drag_x,
                drag_y,
                &mut path,
                pos.as_mut_ptr(),
            ));
            if ret {
                Some((from_glib_full(path), from_glib(pos.assume_init())))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_drag_dest_item")]
    #[doc(alias = "get_drag_dest_item")]
    fn drag_dest_item(&self) -> (TreePath, IconViewDropPosition) {
        unsafe {
            let mut path = ptr::null_mut();
            let mut pos = mem::MaybeUninit::uninit();
            ffi::gtk_icon_view_get_drag_dest_item(
                self.as_ref().to_glib_none().0,
                &mut path,
                pos.as_mut_ptr(),
            );
            (from_glib_full(path), from_glib(pos.assume_init()))
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_at_pos")]
    #[doc(alias = "get_item_at_pos")]
    fn item_at_pos(&self, x: i32, y: i32) -> Option<(TreePath, CellRenderer)> {
        unsafe {
            let mut path = ptr::null_mut();
            let mut cell = ptr::null_mut();
            let ret = from_glib(ffi::gtk_icon_view_get_item_at_pos(
                self.as_ref().to_glib_none().0,
                x,
                y,
                &mut path,
                &mut cell,
            ));
            if ret {
                Some((from_glib_full(path), from_glib_none(cell)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_column")]
    #[doc(alias = "get_item_column")]
    fn item_column(&self, path: &TreePath) -> i32 {
        unsafe {
            ffi::gtk_icon_view_get_item_column(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            )
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_orientation")]
    #[doc(alias = "get_item_orientation")]
    fn item_orientation(&self) -> Orientation {
        unsafe {
            from_glib(ffi::gtk_icon_view_get_item_orientation(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_padding")]
    #[doc(alias = "get_item_padding")]
    fn item_padding(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_item_padding(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_item_row")]
    #[doc(alias = "get_item_row")]
    fn item_row(&self, path: &TreePath) -> i32 {
        unsafe {
            ffi::gtk_icon_view_get_item_row(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            )
        }
    }

    #[doc(alias = "gtk_icon_view_get_item_width")]
    #[doc(alias = "get_item_width")]
    fn item_width(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_item_width(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_margin")]
    #[doc(alias = "get_margin")]
    fn margin(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_margin(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_markup_column")]
    #[doc(alias = "get_markup_column")]
    fn markup_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_markup_column(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_model")]
    #[doc(alias = "get_model")]
    fn model(&self) -> Option<TreeModel> {
        unsafe { from_glib_none(ffi::gtk_icon_view_get_model(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_icon_view_get_path_at_pos")]
    #[doc(alias = "get_path_at_pos")]
    fn path_at_pos(&self, x: i32, y: i32) -> Option<TreePath> {
        unsafe {
            from_glib_full(ffi::gtk_icon_view_get_path_at_pos(
                self.as_ref().to_glib_none().0,
                x,
                y,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_pixbuf_column")]
    #[doc(alias = "get_pixbuf_column")]
    fn pixbuf_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_pixbuf_column(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_reorderable")]
    #[doc(alias = "get_reorderable")]
    fn is_reorderable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_icon_view_get_reorderable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_row_spacing")]
    #[doc(alias = "get_row_spacing")]
    fn row_spacing(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_row_spacing(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_selected_items")]
    #[doc(alias = "get_selected_items")]
    fn selected_items(&self) -> Vec<TreePath> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_icon_view_get_selected_items(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_selection_mode")]
    #[doc(alias = "get_selection_mode")]
    fn selection_mode(&self) -> SelectionMode {
        unsafe {
            from_glib(ffi::gtk_icon_view_get_selection_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_get_spacing")]
    #[doc(alias = "get_spacing")]
    fn spacing(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_spacing(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_text_column")]
    #[doc(alias = "get_text_column")]
    fn text_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_text_column(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_tooltip_column")]
    #[doc(alias = "get_tooltip_column")]
    fn tooltip_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_tooltip_column(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_icon_view_get_tooltip_context")]
    #[doc(alias = "get_tooltip_context")]
    fn tooltip_context(
        &self,
        x: &mut i32,
        y: &mut i32,
        keyboard_tip: bool,
    ) -> Option<(TreeModel, TreePath, TreeIter)> {
        unsafe {
            let mut model = ptr::null_mut();
            let mut path = ptr::null_mut();
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(ffi::gtk_icon_view_get_tooltip_context(
                self.as_ref().to_glib_none().0,
                x,
                y,
                keyboard_tip.into_glib(),
                &mut model,
                &mut path,
                iter.to_glib_none_mut().0,
            ));
            if ret {
                Some((from_glib_none(model), from_glib_full(path), iter))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_get_visible_range")]
    #[doc(alias = "get_visible_range")]
    fn visible_range(&self) -> Option<(TreePath, TreePath)> {
        unsafe {
            let mut start_path = ptr::null_mut();
            let mut end_path = ptr::null_mut();
            let ret = from_glib(ffi::gtk_icon_view_get_visible_range(
                self.as_ref().to_glib_none().0,
                &mut start_path,
                &mut end_path,
            ));
            if ret {
                Some((from_glib_full(start_path), from_glib_full(end_path)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_icon_view_item_activated")]
    fn item_activated(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_item_activated(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_path_is_selected")]
    fn path_is_selected(&self, path: &TreePath) -> bool {
        unsafe {
            from_glib(ffi::gtk_icon_view_path_is_selected(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    #[doc(alias = "gtk_icon_view_scroll_to_path")]
    fn scroll_to_path(&self, path: &TreePath, use_align: bool, row_align: f32, col_align: f32) {
        unsafe {
            ffi::gtk_icon_view_scroll_to_path(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                use_align.into_glib(),
                row_align,
                col_align,
            );
        }
    }

    #[doc(alias = "gtk_icon_view_select_all")]
    fn select_all(&self) {
        unsafe {
            ffi::gtk_icon_view_select_all(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_icon_view_select_path")]
    fn select_path(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_select_path(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_selected_foreach")]
    fn selected_foreach<P: FnMut(&IconView, &TreePath)>(&self, func: P) {
        let func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&IconView, &TreePath)>(
            icon_view: *mut ffi::GtkIconView,
            path: *mut ffi::GtkTreePath,
            data: glib::ffi::gpointer,
        ) {
            let icon_view = from_glib_borrow(icon_view);
            let path = from_glib_borrow(path);
            let callback: *mut P = data as *const _ as usize as *mut P;
            (*callback)(&icon_view, &path)
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &P = &func_data;
        unsafe {
            ffi::gtk_icon_view_selected_foreach(
                self.as_ref().to_glib_none().0,
                func,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_activate_on_single_click")]
    fn set_activate_on_single_click(&self, single: bool) {
        unsafe {
            ffi::gtk_icon_view_set_activate_on_single_click(
                self.as_ref().to_glib_none().0,
                single.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_column_spacing")]
    fn set_column_spacing(&self, column_spacing: i32) {
        unsafe {
            ffi::gtk_icon_view_set_column_spacing(self.as_ref().to_glib_none().0, column_spacing);
        }
    }

    #[doc(alias = "gtk_icon_view_set_columns")]
    fn set_columns(&self, columns: i32) {
        unsafe {
            ffi::gtk_icon_view_set_columns(self.as_ref().to_glib_none().0, columns);
        }
    }

    #[doc(alias = "gtk_icon_view_set_cursor")]
    fn set_cursor(
        &self,
        path: &TreePath,
        cell: Option<&impl IsA<CellRenderer>>,
        start_editing: bool,
    ) {
        unsafe {
            ffi::gtk_icon_view_set_cursor(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                cell.map(|p| p.as_ref()).to_glib_none().0,
                start_editing.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_drag_dest_item")]
    fn set_drag_dest_item(&self, path: Option<&TreePath>, pos: IconViewDropPosition) {
        unsafe {
            ffi::gtk_icon_view_set_drag_dest_item(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
                pos.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_item_orientation")]
    fn set_item_orientation(&self, orientation: Orientation) {
        unsafe {
            ffi::gtk_icon_view_set_item_orientation(
                self.as_ref().to_glib_none().0,
                orientation.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_item_padding")]
    fn set_item_padding(&self, item_padding: i32) {
        unsafe {
            ffi::gtk_icon_view_set_item_padding(self.as_ref().to_glib_none().0, item_padding);
        }
    }

    #[doc(alias = "gtk_icon_view_set_item_width")]
    fn set_item_width(&self, item_width: i32) {
        unsafe {
            ffi::gtk_icon_view_set_item_width(self.as_ref().to_glib_none().0, item_width);
        }
    }

    #[doc(alias = "gtk_icon_view_set_margin")]
    fn set_margin(&self, margin: i32) {
        unsafe {
            ffi::gtk_icon_view_set_margin(self.as_ref().to_glib_none().0, margin);
        }
    }

    #[doc(alias = "gtk_icon_view_set_markup_column")]
    fn set_markup_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_markup_column(self.as_ref().to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_icon_view_set_model")]
    fn set_model(&self, model: Option<&impl IsA<TreeModel>>) {
        unsafe {
            ffi::gtk_icon_view_set_model(
                self.as_ref().to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_pixbuf_column")]
    fn set_pixbuf_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_pixbuf_column(self.as_ref().to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_icon_view_set_reorderable")]
    fn set_reorderable(&self, reorderable: bool) {
        unsafe {
            ffi::gtk_icon_view_set_reorderable(
                self.as_ref().to_glib_none().0,
                reorderable.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_row_spacing")]
    fn set_row_spacing(&self, row_spacing: i32) {
        unsafe {
            ffi::gtk_icon_view_set_row_spacing(self.as_ref().to_glib_none().0, row_spacing);
        }
    }

    #[doc(alias = "gtk_icon_view_set_selection_mode")]
    fn set_selection_mode(&self, mode: SelectionMode) {
        unsafe {
            ffi::gtk_icon_view_set_selection_mode(self.as_ref().to_glib_none().0, mode.into_glib());
        }
    }

    #[doc(alias = "gtk_icon_view_set_spacing")]
    fn set_spacing(&self, spacing: i32) {
        unsafe {
            ffi::gtk_icon_view_set_spacing(self.as_ref().to_glib_none().0, spacing);
        }
    }

    #[doc(alias = "gtk_icon_view_set_text_column")]
    fn set_text_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_text_column(self.as_ref().to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_icon_view_set_tooltip_cell")]
    fn set_tooltip_cell(
        &self,
        tooltip: &Tooltip,
        path: &TreePath,
        cell: Option<&impl IsA<CellRenderer>>,
    ) {
        unsafe {
            ffi::gtk_icon_view_set_tooltip_cell(
                self.as_ref().to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                cell.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_icon_view_set_tooltip_column")]
    fn set_tooltip_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_tooltip_column(self.as_ref().to_glib_none().0, column);
        }
    }

    #[doc(alias = "gtk_icon_view_set_tooltip_item")]
    fn set_tooltip_item(&self, tooltip: &Tooltip, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_set_tooltip_item(
                self.as_ref().to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_unselect_all")]
    fn unselect_all(&self) {
        unsafe {
            ffi::gtk_icon_view_unselect_all(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_icon_view_unselect_path")]
    fn unselect_path(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_unselect_path(
                self.as_ref().to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "gtk_icon_view_unset_model_drag_dest")]
    fn unset_model_drag_dest(&self) {
        unsafe {
            ffi::gtk_icon_view_unset_model_drag_dest(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_icon_view_unset_model_drag_source")]
    fn unset_model_drag_source(&self) {
        unsafe {
            ffi::gtk_icon_view_unset_model_drag_source(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "cell-area")]
    fn cell_area(&self) -> Option<CellArea> {
        ObjectExt::property(self.as_ref(), "cell-area")
    }

    #[doc(alias = "activate-cursor-item")]
    fn connect_activate_cursor_item<F: Fn(&Self) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn activate_cursor_item_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) -> bool + 'static,
        >(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-cursor-item\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_cursor_item_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_cursor_item(&self) -> bool {
        self.emit_by_name("activate-cursor-item", &[])
    }

    #[doc(alias = "item-activated")]
    fn connect_item_activated<F: Fn(&Self, &TreePath) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn item_activated_trampoline<
            P: IsA<IconView>,
            F: Fn(&P, &TreePath) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                IconView::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(path),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"item-activated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    item_activated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "move-cursor")]
    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P: IsA<IconView>,
            F: Fn(&P, MovementStep, i32) -> bool + 'static,
        >(
            this: *mut ffi::GtkIconView,
            step: ffi::GtkMovementStep,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                IconView::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(step),
                count,
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, count: i32) -> bool {
        self.emit_by_name("move-cursor", &[&step, &count])
    }

    #[doc(alias = "select-all")]
    fn connect_select_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<P: IsA<IconView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_all(&self) {
        self.emit_by_name::<()>("select-all", &[]);
    }

    #[doc(alias = "select-cursor-item")]
    fn connect_select_cursor_item<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_cursor_item_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"select-cursor-item\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    select_cursor_item_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_select_cursor_item(&self) {
        self.emit_by_name::<()>("select-cursor-item", &[]);
    }

    #[doc(alias = "selection-changed")]
    fn connect_selection_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn selection_changed_trampoline<P: IsA<IconView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"selection-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    selection_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "toggle-cursor-item")]
    fn connect_toggle_cursor_item<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_item_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"toggle-cursor-item\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    toggle_cursor_item_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_toggle_cursor_item(&self) {
        self.emit_by_name::<()>("toggle-cursor-item", &[]);
    }

    #[doc(alias = "unselect-all")]
    fn connect_unselect_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unselect_all_trampoline<P: IsA<IconView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"unselect-all\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    unselect_all_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_unselect_all(&self) {
        self.emit_by_name::<()>("unselect-all", &[]);
    }

    #[doc(alias = "activate-on-single-click")]
    fn connect_activate_on_single_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activate_on_single_click_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::activate-on-single-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_activate_on_single_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "column-spacing")]
    fn connect_column_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_column_spacing_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::column-spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_column_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "columns")]
    fn connect_columns_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_columns_trampoline<P: IsA<IconView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::columns\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_columns_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "item-orientation")]
    fn connect_item_orientation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_item_orientation_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::item-orientation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_item_orientation_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "item-padding")]
    fn connect_item_padding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_item_padding_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::item-padding\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_item_padding_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "item-width")]
    fn connect_item_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_item_width_trampoline<P: IsA<IconView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::item-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_item_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "markup-column")]
    fn connect_markup_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_markup_column_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::markup-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_markup_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "model")]
    fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_model_trampoline<P: IsA<IconView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::model\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_model_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pixbuf-column")]
    fn connect_pixbuf_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixbuf_column_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixbuf-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixbuf_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reorderable")]
    fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reorderable_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reorderable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reorderable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "row-spacing")]
    fn connect_row_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_row_spacing_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::row-spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_row_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "selection-mode")]
    fn connect_selection_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selection_mode_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::selection-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_selection_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "spacing")]
    fn connect_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spacing_trampoline<P: IsA<IconView>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text-column")]
    fn connect_text_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_column_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tooltip-column")]
    fn connect_tooltip_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_column_trampoline<
            P: IsA<IconView>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(IconView::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tooltip-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tooltip_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<IconView>> IconViewExt for O {}

impl fmt::Display for IconView {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("IconView")
    }
}
