/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

/* -- THIS FILE IS AUTO-GENERATED -- */

#include "mpiimpl.h"

/* -- Begin Profiling Symbol Block for routine MPI_Abi_get_fortran_info */
#if defined(HAVE_PRAGMA_WEAK)
#pragma weak MPI_Abi_get_fortran_info = PMPI_Abi_get_fortran_info
#elif defined(HAVE_PRAGMA_HP_SEC_DEF)
#pragma _HP_SECONDARY_DEF PMPI_Abi_get_fortran_info  MPI_Abi_get_fortran_info
#elif defined(HAVE_PRAGMA_CRI_DUP)
#pragma _CRI duplicate MPI_Abi_get_fortran_info as PMPI_Abi_get_fortran_info
#elif defined(HAVE_WEAK_ATTRIBUTE)
int MPI_Abi_get_fortran_info(MPI_Info *info)
     __attribute__ ((weak, alias("PMPI_Abi_get_fortran_info")));
#endif
/* -- End Profiling Symbol Block */

/* Define MPICH_MPI_FROM_PMPI if weak symbols are not supported to build
   the MPI routines */
#ifndef MPICH_MPI_FROM_PMPI
#undef MPI_Abi_get_fortran_info
#define MPI_Abi_get_fortran_info PMPI_Abi_get_fortran_info
#endif /* MPICH_MPI_FROM_PMPI */

static int internal_Abi_get_fortran_info(MPI_Info *info)
{
    int mpi_errno = MPI_SUCCESS;

    MPIR_ERRTEST_INITIALIZED_ORDIE();

    MPID_THREAD_CS_ENTER(GLOBAL, MPIR_THREAD_GLOBAL_ALLFUNC_MUTEX);
    MPIR_FUNC_TERSE_ENTER;

#ifdef HAVE_ERROR_CHECKING
    {
        MPID_BEGIN_ERROR_CHECKS;
        {
            MPIR_ERRTEST_ARGNULL(info, "info", mpi_errno);
        }
        MPID_END_ERROR_CHECKS;
    }
#endif /* HAVE_ERROR_CHECKING */

    /* ... body of routine ... */
#ifdef HAVE_FORTRAN_BINDING
    MPIR_Info *info_ptr;
    mpi_errno = MPIR_Info_alloc(&info_ptr);
    MPIR_ERR_CHECK(mpi_errno);

    MPI_Datatype type;
    char str[8];
    #define PUSH_TYPE_INFO(type_, keyname) \
    do { \
        type = type_; \
        MPIR_DATATYPE_REPLACE_BUILTIN(type); \
        snprintf(str, sizeof(str), "%d", MPIR_Datatype_get_basic_size(type)); \
        MPIR_Info_push(info_ptr, keyname, str); \
    } while (0)
    PUSH_TYPE_INFO(MPI_LOGICAL, "mpi_logical_size");
    PUSH_TYPE_INFO(MPI_INTEGER, "mpi_integer_size");
    PUSH_TYPE_INFO(MPI_REAL, "mpi_real_size");
    PUSH_TYPE_INFO(MPI_DOUBLE_PRECISION, "mpi_double_precision_size");
    #undef PUSH_TYPE_INFO
    #define PUSH_TYPE_INFO(type_, keyname) \
    do { \
        type = type_; \
        MPIR_DATATYPE_REPLACE_BUILTIN(type); \
        MPIR_Info_push(info_ptr, keyname, type != MPI_DATATYPE_NULL ? "true" : "false"); \
    } while (0)
    PUSH_TYPE_INFO(MPI_LOGICAL1, "mpi_logical1_supported");
    PUSH_TYPE_INFO(MPI_LOGICAL2, "mpi_logical2_supported");
    PUSH_TYPE_INFO(MPI_LOGICAL4, "mpi_logical4_supported");
    PUSH_TYPE_INFO(MPI_LOGICAL8, "mpi_logical8_supported");
    PUSH_TYPE_INFO(MPI_LOGICAL16, "mpi_logical16_supported");
    PUSH_TYPE_INFO(MPI_INTEGER1, "mpi_integer1_supported");
    PUSH_TYPE_INFO(MPI_INTEGER2, "mpi_integer2_supported");
    PUSH_TYPE_INFO(MPI_INTEGER4, "mpi_integer4_supported");
    PUSH_TYPE_INFO(MPI_INTEGER8, "mpi_integer8_supported");
    PUSH_TYPE_INFO(MPI_INTEGER16, "mpi_integer16_supported");
    PUSH_TYPE_INFO(MPI_REAL2, "mpi_real2_supported");
    PUSH_TYPE_INFO(MPI_REAL4, "mpi_real4_supported");
    PUSH_TYPE_INFO(MPI_REAL8, "mpi_real8_supported");
    PUSH_TYPE_INFO(MPI_REAL16, "mpi_real16_supported");
    PUSH_TYPE_INFO(MPI_COMPLEX4, "mpi_complex4_supported");
    PUSH_TYPE_INFO(MPI_COMPLEX8, "mpi_complex8_supported");
    PUSH_TYPE_INFO(MPI_COMPLEX16, "mpi_complex16_supported");
    PUSH_TYPE_INFO(MPI_COMPLEX32, "mpi_complex32_supported");
    PUSH_TYPE_INFO(MPI_DOUBLE_COMPLEX, "mpi_double_complex_supported");
    #undef PUSH_TYPE_INFO
    *info = info_ptr->handle;
#else
    *info = MPI_INFO_NULL;
    MPIR_ERR_CHECK(mpi_errno);
#endif
    /* ... end of body of routine ... */

  fn_exit:
    MPIR_FUNC_TERSE_EXIT;

    MPID_THREAD_CS_EXIT(GLOBAL, MPIR_THREAD_GLOBAL_ALLFUNC_MUTEX);
    return mpi_errno;

  fn_fail:
    /* --BEGIN ERROR HANDLINE-- */
#ifdef HAVE_ERROR_CHECKING
    mpi_errno = MPIR_Err_create_code(mpi_errno, MPIR_ERR_RECOVERABLE, __func__, __LINE__, MPI_ERR_OTHER,
                                     "**mpi_abi_get_fortran_info", "**mpi_abi_get_fortran_info %p",
                                     info);
#endif
    mpi_errno = MPIR_Err_return_comm(0, __func__, mpi_errno);
    /* --END ERROR HANDLING-- */
    goto fn_exit;
}

#ifdef ENABLE_QMPI
#ifndef MPICH_MPI_FROM_PMPI
int QMPI_Abi_get_fortran_info(QMPI_Context context, int tool_id, MPI_Info *info)
{
    return internal_Abi_get_fortran_info(info);
}
#endif /* MPICH_MPI_FROM_PMPI */
int MPI_Abi_get_fortran_info(MPI_Info *info)
{
    QMPI_Context context;
    QMPI_Abi_get_fortran_info_t *fn_ptr;

    context.storage_stack = NULL;

    if (MPIR_QMPI_num_tools == 0)
        return QMPI_Abi_get_fortran_info(context, 0, info);

    fn_ptr = (QMPI_Abi_get_fortran_info_t *) MPIR_QMPI_first_fn_ptrs[MPI_ABI_GET_FORTRAN_INFO_T];

    return (*fn_ptr) (context, MPIR_QMPI_first_tool_ids[MPI_ABI_GET_FORTRAN_INFO_T], info);
}
#else /* ENABLE_QMPI */
int MPI_Abi_get_fortran_info(MPI_Info *info)
{
    return internal_Abi_get_fortran_info(info);
}

#endif /* ENABLE_QMPI */
