// Copyright 2009-present MongoDB, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <chrono>

#include <bsoncxx/builder/basic/document.hpp>

#include <mongocxx/instance.hpp>
#include <mongocxx/options/delete.hpp>

#include <bsoncxx/test/catch.hh>

#include <mongocxx/test/catch_helpers.hh>

namespace {
using namespace bsoncxx::builder::basic;
using namespace mongocxx;

TEST_CASE("delete_options", "[delete][option]") {
    instance::current();

    options::delete_options del;

    auto collation = make_document(kvp("locale", "en_US"));

    CHECK_OPTIONAL_ARGUMENT(del, collation, collation.view());
    CHECK_OPTIONAL_ARGUMENT(del, write_concern, write_concern{});
}
} // namespace
